/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.IntOrString;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="NetworkPolicyPort describes a port to allow traffic on")
public class V1NetworkPolicyPort {
    public static final String SERIALIZED_NAME_END_PORT = "endPort";
    @SerializedName(value="endPort")
    private Integer endPort;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    private IntOrString port;
    public static final String SERIALIZED_NAME_PROTOCOL = "protocol";
    @SerializedName(value="protocol")
    private String protocol;

    public V1NetworkPolicyPort endPort(Integer endPort) {
        this.endPort = endPort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, indicates that the range of ports from port to endPort, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port. This feature is in Beta state and is enabled by default. It can be disabled using the Feature Gate \"NetworkPolicyEndPort\".")
    public Integer getEndPort() {
        return this.endPort;
    }

    public void setEndPort(Integer endPort) {
        this.endPort = endPort;
    }

    public V1NetworkPolicyPort port(IntOrString port) {
        this.port = port;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number.")
    public IntOrString getPort() {
        return this.port;
    }

    public void setPort(IntOrString port) {
        this.port = port;
    }

    public V1NetworkPolicyPort protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NetworkPolicyPort v1NetworkPolicyPort = (V1NetworkPolicyPort)o;
        return Objects.equals(this.endPort, v1NetworkPolicyPort.endPort) && Objects.equals(this.port, v1NetworkPolicyPort.port) && Objects.equals(this.protocol, v1NetworkPolicyPort.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.endPort, this.port, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NetworkPolicyPort {\n");
        sb.append("    endPort: ").append(this.toIndentedString(this.endPort)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

