/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.models.V1NamespaceCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="NamespaceStatus is information about the current status of a Namespace.")
public class V1NamespaceStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1NamespaceCondition> conditions = null;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    private PhaseEnum phase;

    public V1NamespaceStatus conditions(List<V1NamespaceCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1NamespaceStatus addConditionsItem(V1NamespaceCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1NamespaceCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a namespace's current state.")
    public List<V1NamespaceCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1NamespaceCondition> conditions) {
        this.conditions = conditions;
    }

    public V1NamespaceStatus phase(PhaseEnum phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/  Possible enum values:  - `\"Active\"` means the namespace is available for use in the system  - `\"Terminating\"` means the namespace is undergoing graceful termination")
    public PhaseEnum getPhase() {
        return this.phase;
    }

    public void setPhase(PhaseEnum phase) {
        this.phase = phase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NamespaceStatus v1NamespaceStatus = (V1NamespaceStatus)o;
        return Objects.equals(this.conditions, v1NamespaceStatus.conditions) && Objects.equals((Object)this.phase, (Object)v1NamespaceStatus.phase);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditions, this.phase});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NamespaceStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString((Object)this.phase)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PhaseEnum {
        ACTIVE("Active"),
        TERMINATING("Terminating");

        private String value;

        private PhaseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PhaseEnum fromValue(String value) {
            for (PhaseEnum b : PhaseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PhaseEnum> {
            public void write(JsonWriter jsonWriter, PhaseEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PhaseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PhaseEnum.fromValue(value);
            }
        }
    }
}

