/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V2beta1PodsMetricSource;
import io.kubernetes.client.openapi.models.V2beta1PodsMetricSourceFluent;
import java.util.Objects;

public class V2beta1PodsMetricSourceFluentImpl<A extends V2beta1PodsMetricSourceFluent<A>>
extends BaseFluent<A>
implements V2beta1PodsMetricSourceFluent<A> {
    private String metricName;
    private V1LabelSelectorBuilder selector;
    private Quantity targetAverageValue;

    public V2beta1PodsMetricSourceFluentImpl() {
    }

    public V2beta1PodsMetricSourceFluentImpl(V2beta1PodsMetricSource instance) {
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
        this.withTargetAverageValue(instance.getTargetAverageValue());
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    public A withNewMetricName(String arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuilder arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuffer arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    @Deprecated
    public V1LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(V1LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public V2beta1PodsMetricSourceFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public V2beta1PodsMetricSourceFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public V2beta1PodsMetricSourceFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public V2beta1PodsMetricSourceFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V2beta1PodsMetricSourceFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    @Override
    public A withTargetAverageValue(Quantity targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    @Override
    public A withNewTargetAverageValue(String value) {
        return this.withTargetAverageValue(new Quantity(value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1PodsMetricSourceFluentImpl that = (V2beta1PodsMetricSourceFluentImpl)o;
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.targetAverageValue != null ? !this.targetAverageValue.equals(that.targetAverageValue) : that.targetAverageValue != null);
    }

    public int hashCode() {
        return Objects.hash(this.metricName, this.selector, this.targetAverageValue, super.hashCode());
    }

    public class SelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V2beta1PodsMetricSourceFluent.SelectorNested<N>>
    implements V2beta1PodsMetricSourceFluent.SelectorNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2beta1PodsMetricSourceFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

