package io.kubernetes.client.openapi.models;

import java.lang.Integer;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.custom.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V2beta2MetricValueStatusFluentImpl<A extends V2beta2MetricValueStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta2MetricValueStatusFluent<A> {

    private Integer averageUtilization;
    private Quantity averageValue;
    private Quantity value;

    public V2beta2MetricValueStatusFluentImpl() { 
    }


    public V2beta2MetricValueStatusFluentImpl(V2beta2MetricValueStatus instance) { 
        this.withAverageUtilization(instance.getAverageUtilization());

        this.withAverageValue(instance.getAverageValue());

        this.withValue(instance.getValue());

    }


    public Integer getAverageUtilization() {
        return this.averageUtilization;
    }

    public A withAverageUtilization(Integer averageUtilization) {
        this.averageUtilization=averageUtilization; return (A) this;
    }

    public Boolean hasAverageUtilization() {
        return this.averageUtilization != null;
    }

    public Quantity getAverageValue() {
        return this.averageValue;
    }

    public A withAverageValue(Quantity averageValue) {
        this.averageValue=averageValue; return (A) this;
    }

    public Boolean hasAverageValue() {
        return this.averageValue != null;
    }

    public A withNewAverageValue(final String value) {
        return (A)withAverageValue(new Quantity(value));
    }

    public Quantity getValue() {
        return this.value;
    }

    public A withValue(Quantity value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(final String value) {
        return (A)withValue(new Quantity(value));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V2beta2MetricValueStatusFluentImpl that = (V2beta2MetricValueStatusFluentImpl) o;
        if (averageUtilization != null ? !averageUtilization.equals(that.averageUtilization) :that.averageUtilization != null) return false;
        if (averageValue != null ? !averageValue.equals(that.averageValue) :that.averageValue != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(averageUtilization,  averageValue,  value,  super.hashCode());
    }

}
