package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1HorizontalPodAutoscalerListBuilder extends V2beta1HorizontalPodAutoscalerListFluentImpl<V2beta1HorizontalPodAutoscalerListBuilder> implements VisitableBuilder<V2beta1HorizontalPodAutoscalerList,V2beta1HorizontalPodAutoscalerListBuilder> {

    V2beta1HorizontalPodAutoscalerListFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta1HorizontalPodAutoscalerListBuilder() { 
        this(true);
    }


    public V2beta1HorizontalPodAutoscalerListBuilder(Boolean validationEnabled) { 
        this(new V2beta1HorizontalPodAutoscalerList(), validationEnabled);
    }


    public V2beta1HorizontalPodAutoscalerListBuilder(V2beta1HorizontalPodAutoscalerListFluent<?> fluent) { 
        this(fluent, true);
    }


    public V2beta1HorizontalPodAutoscalerListBuilder(V2beta1HorizontalPodAutoscalerListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V2beta1HorizontalPodAutoscalerList(), validationEnabled);
    }


    public V2beta1HorizontalPodAutoscalerListBuilder(V2beta1HorizontalPodAutoscalerListFluent<?> fluent,V2beta1HorizontalPodAutoscalerList instance) { 
        this(fluent, instance, true);
    }


    public V2beta1HorizontalPodAutoscalerListBuilder(V2beta1HorizontalPodAutoscalerListFluent<?> fluent,V2beta1HorizontalPodAutoscalerList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withItems(instance.getItems());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public V2beta1HorizontalPodAutoscalerListBuilder(V2beta1HorizontalPodAutoscalerList instance) { 
        this(instance,true);
    }


    public V2beta1HorizontalPodAutoscalerListBuilder(V2beta1HorizontalPodAutoscalerList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withItems(instance.getItems());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public V2beta1HorizontalPodAutoscalerList build() {
        V2beta1HorizontalPodAutoscalerList buildable = new V2beta1HorizontalPodAutoscalerList();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setItems(fluent.getItems());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V2beta1HorizontalPodAutoscalerListBuilder that = (V2beta1HorizontalPodAutoscalerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
