package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1VolumeAttachmentSourceBuilder extends V1beta1VolumeAttachmentSourceFluentImpl<V1beta1VolumeAttachmentSourceBuilder> implements VisitableBuilder<V1beta1VolumeAttachmentSource,V1beta1VolumeAttachmentSourceBuilder> {

    V1beta1VolumeAttachmentSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1VolumeAttachmentSourceBuilder() { 
        this(true);
    }


    public V1beta1VolumeAttachmentSourceBuilder(Boolean validationEnabled) { 
        this(new V1beta1VolumeAttachmentSource(), validationEnabled);
    }


    public V1beta1VolumeAttachmentSourceBuilder(V1beta1VolumeAttachmentSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1beta1VolumeAttachmentSourceBuilder(V1beta1VolumeAttachmentSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1beta1VolumeAttachmentSource(), validationEnabled);
    }


    public V1beta1VolumeAttachmentSourceBuilder(V1beta1VolumeAttachmentSourceFluent<?> fluent,V1beta1VolumeAttachmentSource instance) { 
        this(fluent, instance, true);
    }


    public V1beta1VolumeAttachmentSourceBuilder(V1beta1VolumeAttachmentSourceFluent<?> fluent,V1beta1VolumeAttachmentSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withInlineVolumeSpec(instance.getInlineVolumeSpec());

        fluent.withPersistentVolumeName(instance.getPersistentVolumeName());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1VolumeAttachmentSourceBuilder(V1beta1VolumeAttachmentSource instance) { 
        this(instance,true);
    }


    public V1beta1VolumeAttachmentSourceBuilder(V1beta1VolumeAttachmentSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withInlineVolumeSpec(instance.getInlineVolumeSpec());

        this.withPersistentVolumeName(instance.getPersistentVolumeName());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1VolumeAttachmentSource build() {
        V1beta1VolumeAttachmentSource buildable = new V1beta1VolumeAttachmentSource();
        buildable.setInlineVolumeSpec(fluent.getInlineVolumeSpec());
        buildable.setPersistentVolumeName(fluent.getPersistentVolumeName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1beta1VolumeAttachmentSourceBuilder that = (V1beta1VolumeAttachmentSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
