package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1RuntimeClassStrategyOptionsBuilder extends V1beta1RuntimeClassStrategyOptionsFluentImpl<V1beta1RuntimeClassStrategyOptionsBuilder> implements VisitableBuilder<V1beta1RuntimeClassStrategyOptions,V1beta1RuntimeClassStrategyOptionsBuilder> {

    V1beta1RuntimeClassStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1RuntimeClassStrategyOptionsBuilder() { 
        this(true);
    }


    public V1beta1RuntimeClassStrategyOptionsBuilder(Boolean validationEnabled) { 
        this(new V1beta1RuntimeClassStrategyOptions(), validationEnabled);
    }


    public V1beta1RuntimeClassStrategyOptionsBuilder(V1beta1RuntimeClassStrategyOptionsFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1beta1RuntimeClassStrategyOptionsBuilder(V1beta1RuntimeClassStrategyOptionsFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1beta1RuntimeClassStrategyOptions(), validationEnabled);
    }


    public V1beta1RuntimeClassStrategyOptionsBuilder(V1beta1RuntimeClassStrategyOptionsFluent<?> fluent,V1beta1RuntimeClassStrategyOptions instance) { 
        this(fluent, instance, true);
    }


    public V1beta1RuntimeClassStrategyOptionsBuilder(V1beta1RuntimeClassStrategyOptionsFluent<?> fluent,V1beta1RuntimeClassStrategyOptions instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames());

        fluent.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1RuntimeClassStrategyOptionsBuilder(V1beta1RuntimeClassStrategyOptions instance) { 
        this(instance,true);
    }


    public V1beta1RuntimeClassStrategyOptionsBuilder(V1beta1RuntimeClassStrategyOptions instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames());

        this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1RuntimeClassStrategyOptions build() {
        V1beta1RuntimeClassStrategyOptions buildable = new V1beta1RuntimeClassStrategyOptions();
        buildable.setAllowedRuntimeClassNames(fluent.getAllowedRuntimeClassNames());
        buildable.setDefaultRuntimeClassName(fluent.getDefaultRuntimeClassName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1beta1RuntimeClassStrategyOptionsBuilder that = (V1beta1RuntimeClassStrategyOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
