package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class V1beta1RuntimeClassFluentImpl<A extends V1beta1RuntimeClassFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1RuntimeClassFluent<A> {

    private String apiVersion;
    private String handler;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1beta1OverheadBuilder overhead;
    private V1beta1SchedulingBuilder scheduling;

    public V1beta1RuntimeClassFluentImpl() { 
    }


    public V1beta1RuntimeClassFluentImpl(V1beta1RuntimeClass instance) { 
        this.withApiVersion(instance.getApiVersion());

        this.withHandler(instance.getHandler());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withOverhead(instance.getOverhead());

        this.withScheduling(instance.getScheduling());

    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getHandler() {
        return this.handler;
    }

    public A withHandler(String handler) {
        this.handler=handler; return (A) this;
    }

    public Boolean hasHandler() {
        return this.handler != null;
    }

    public A withNewHandler(String arg1) {
        return (A)withHandler(new String(arg1));
    }

    public A withNewHandler(StringBuilder arg1) {
        return (A)withHandler(new String(arg1));
    }

    public A withNewHandler(StringBuffer arg1) {
        return (A)withHandler(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public V1beta1RuntimeClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public V1beta1RuntimeClassFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public V1beta1RuntimeClassFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public V1beta1RuntimeClassFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1beta1RuntimeClassFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOverhead instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1Overhead getOverhead() {
        return this.overhead!=null?this.overhead.build():null;
    }

    public V1beta1Overhead buildOverhead() {
        return this.overhead!=null?this.overhead.build():null;
    }

    public A withOverhead(V1beta1Overhead overhead) {
        _visitables.get("overhead").remove(this.overhead);
        if (overhead!=null){ this.overhead= new V1beta1OverheadBuilder(overhead); _visitables.get("overhead").add(this.overhead);} return (A) this;
    }

    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    public V1beta1RuntimeClassFluent.OverheadNested<A> withNewOverhead() {
        return new OverheadNestedImpl();
    }

    public V1beta1RuntimeClassFluent.OverheadNested<A> withNewOverheadLike(V1beta1Overhead item) {
        return new OverheadNestedImpl(item);
    }

    public V1beta1RuntimeClassFluent.OverheadNested<A> editOverhead() {
        return withNewOverheadLike(getOverhead());
    }

    public V1beta1RuntimeClassFluent.OverheadNested<A> editOrNewOverhead() {
        return withNewOverheadLike(getOverhead() != null ? getOverhead(): new V1beta1OverheadBuilder().build());
    }

    public V1beta1RuntimeClassFluent.OverheadNested<A> editOrNewOverheadLike(V1beta1Overhead item) {
        return withNewOverheadLike(getOverhead() != null ? getOverhead(): item);
    }

    
/**
 * This method has been deprecated, please use method buildScheduling instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1Scheduling getScheduling() {
        return this.scheduling!=null?this.scheduling.build():null;
    }

    public V1beta1Scheduling buildScheduling() {
        return this.scheduling!=null?this.scheduling.build():null;
    }

    public A withScheduling(V1beta1Scheduling scheduling) {
        _visitables.get("scheduling").remove(this.scheduling);
        if (scheduling!=null){ this.scheduling= new V1beta1SchedulingBuilder(scheduling); _visitables.get("scheduling").add(this.scheduling);} return (A) this;
    }

    public Boolean hasScheduling() {
        return this.scheduling != null;
    }

    public V1beta1RuntimeClassFluent.SchedulingNested<A> withNewScheduling() {
        return new SchedulingNestedImpl();
    }

    public V1beta1RuntimeClassFluent.SchedulingNested<A> withNewSchedulingLike(V1beta1Scheduling item) {
        return new SchedulingNestedImpl(item);
    }

    public V1beta1RuntimeClassFluent.SchedulingNested<A> editScheduling() {
        return withNewSchedulingLike(getScheduling());
    }

    public V1beta1RuntimeClassFluent.SchedulingNested<A> editOrNewScheduling() {
        return withNewSchedulingLike(getScheduling() != null ? getScheduling(): new V1beta1SchedulingBuilder().build());
    }

    public V1beta1RuntimeClassFluent.SchedulingNested<A> editOrNewSchedulingLike(V1beta1Scheduling item) {
        return withNewSchedulingLike(getScheduling() != null ? getScheduling(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1beta1RuntimeClassFluentImpl that = (V1beta1RuntimeClassFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (handler != null ? !handler.equals(that.handler) :that.handler != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (overhead != null ? !overhead.equals(that.overhead) :that.overhead != null) return false;
        if (scheduling != null ? !scheduling.equals(that.scheduling) :that.scheduling != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  handler,  kind,  metadata,  overhead,  scheduling,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1beta1RuntimeClassFluent.MetadataNested<N>> implements V1beta1RuntimeClassFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) V1beta1RuntimeClassFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


    public class OverheadNestedImpl<N> extends V1beta1OverheadFluentImpl<V1beta1RuntimeClassFluent.OverheadNested<N>> implements V1beta1RuntimeClassFluent.OverheadNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1OverheadBuilder builder;

        OverheadNestedImpl(V1beta1Overhead item) {
            this.builder = new V1beta1OverheadBuilder(this, item);
        }

        OverheadNestedImpl() {
            this.builder = new V1beta1OverheadBuilder(this);
        }

        public N and() {
             return (N) V1beta1RuntimeClassFluentImpl.this.withOverhead(builder.build());
        }

        public N endOverhead() {
             return and();
        }
    }


    public class SchedulingNestedImpl<N> extends V1beta1SchedulingFluentImpl<V1beta1RuntimeClassFluent.SchedulingNested<N>> implements V1beta1RuntimeClassFluent.SchedulingNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1SchedulingBuilder builder;

        SchedulingNestedImpl(V1beta1Scheduling item) {
            this.builder = new V1beta1SchedulingBuilder(this, item);
        }

        SchedulingNestedImpl() {
            this.builder = new V1beta1SchedulingBuilder(this);
        }

        public N and() {
             return (N) V1beta1RuntimeClassFluentImpl.this.withScheduling(builder.build());
        }

        public N endScheduling() {
             return and();
        }
    }


}
