package io.kubernetes.client.openapi.models;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1beta1LeaseSpecFluentImpl<A extends V1beta1LeaseSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1LeaseSpecFluent<A> {

    private DateTime acquireTime;
    private String holderIdentity;
    private Integer leaseDurationSeconds;
    private Integer leaseTransitions;
    private DateTime renewTime;

    public V1beta1LeaseSpecFluentImpl() { 
    }


    public V1beta1LeaseSpecFluentImpl(V1beta1LeaseSpec instance) { 
        this.withAcquireTime(instance.getAcquireTime());

        this.withHolderIdentity(instance.getHolderIdentity());

        this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());

        this.withLeaseTransitions(instance.getLeaseTransitions());

        this.withRenewTime(instance.getRenewTime());

    }


    public DateTime getAcquireTime() {
        return this.acquireTime;
    }

    public A withAcquireTime(DateTime acquireTime) {
        this.acquireTime=acquireTime; return (A) this;
    }

    public Boolean hasAcquireTime() {
        return this.acquireTime != null;
    }

    public A withNewAcquireTime(int arg0,int arg1,int arg2,int arg3,int arg4) {
        return (A)withAcquireTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewAcquireTime(Object arg0) {
        return (A)withAcquireTime(new DateTime(arg0));
    }

    public A withNewAcquireTime(long arg0) {
        return (A)withAcquireTime(new DateTime(arg0));
    }

    public String getHolderIdentity() {
        return this.holderIdentity;
    }

    public A withHolderIdentity(String holderIdentity) {
        this.holderIdentity=holderIdentity; return (A) this;
    }

    public Boolean hasHolderIdentity() {
        return this.holderIdentity != null;
    }

    public A withNewHolderIdentity(String arg1) {
        return (A)withHolderIdentity(new String(arg1));
    }

    public A withNewHolderIdentity(StringBuilder arg1) {
        return (A)withHolderIdentity(new String(arg1));
    }

    public A withNewHolderIdentity(StringBuffer arg1) {
        return (A)withHolderIdentity(new String(arg1));
    }

    public Integer getLeaseDurationSeconds() {
        return this.leaseDurationSeconds;
    }

    public A withLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds=leaseDurationSeconds; return (A) this;
    }

    public Boolean hasLeaseDurationSeconds() {
        return this.leaseDurationSeconds != null;
    }

    public Integer getLeaseTransitions() {
        return this.leaseTransitions;
    }

    public A withLeaseTransitions(Integer leaseTransitions) {
        this.leaseTransitions=leaseTransitions; return (A) this;
    }

    public Boolean hasLeaseTransitions() {
        return this.leaseTransitions != null;
    }

    public DateTime getRenewTime() {
        return this.renewTime;
    }

    public A withRenewTime(DateTime renewTime) {
        this.renewTime=renewTime; return (A) this;
    }

    public Boolean hasRenewTime() {
        return this.renewTime != null;
    }

    public A withNewRenewTime(int arg0,int arg1,int arg2,int arg3,int arg4) {
        return (A)withRenewTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewRenewTime(Object arg0) {
        return (A)withRenewTime(new DateTime(arg0));
    }

    public A withNewRenewTime(long arg0) {
        return (A)withRenewTime(new DateTime(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1beta1LeaseSpecFluentImpl that = (V1beta1LeaseSpecFluentImpl) o;
        if (acquireTime != null ? !acquireTime.equals(that.acquireTime) :that.acquireTime != null) return false;
        if (holderIdentity != null ? !holderIdentity.equals(that.holderIdentity) :that.holderIdentity != null) return false;
        if (leaseDurationSeconds != null ? !leaseDurationSeconds.equals(that.leaseDurationSeconds) :that.leaseDurationSeconds != null) return false;
        if (leaseTransitions != null ? !leaseTransitions.equals(that.leaseTransitions) :that.leaseTransitions != null) return false;
        if (renewTime != null ? !renewTime.equals(that.renewTime) :that.renewTime != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(acquireTime,  holderIdentity,  leaseDurationSeconds,  leaseTransitions,  renewTime,  super.hashCode());
    }

}
