package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1CustomResourceDefinitionStatusBuilder extends V1beta1CustomResourceDefinitionStatusFluentImpl<V1beta1CustomResourceDefinitionStatusBuilder> implements VisitableBuilder<V1beta1CustomResourceDefinitionStatus,V1beta1CustomResourceDefinitionStatusBuilder> {

    V1beta1CustomResourceDefinitionStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1CustomResourceDefinitionStatusBuilder() { 
        this(true);
    }


    public V1beta1CustomResourceDefinitionStatusBuilder(Boolean validationEnabled) { 
        this(new V1beta1CustomResourceDefinitionStatus(), validationEnabled);
    }


    public V1beta1CustomResourceDefinitionStatusBuilder(V1beta1CustomResourceDefinitionStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1beta1CustomResourceDefinitionStatusBuilder(V1beta1CustomResourceDefinitionStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1beta1CustomResourceDefinitionStatus(), validationEnabled);
    }


    public V1beta1CustomResourceDefinitionStatusBuilder(V1beta1CustomResourceDefinitionStatusFluent<?> fluent,V1beta1CustomResourceDefinitionStatus instance) { 
        this(fluent, instance, true);
    }


    public V1beta1CustomResourceDefinitionStatusBuilder(V1beta1CustomResourceDefinitionStatusFluent<?> fluent,V1beta1CustomResourceDefinitionStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAcceptedNames(instance.getAcceptedNames());

        fluent.withConditions(instance.getConditions());

        fluent.withStoredVersions(instance.getStoredVersions());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1CustomResourceDefinitionStatusBuilder(V1beta1CustomResourceDefinitionStatus instance) { 
        this(instance,true);
    }


    public V1beta1CustomResourceDefinitionStatusBuilder(V1beta1CustomResourceDefinitionStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAcceptedNames(instance.getAcceptedNames());

        this.withConditions(instance.getConditions());

        this.withStoredVersions(instance.getStoredVersions());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1CustomResourceDefinitionStatus build() {
        V1beta1CustomResourceDefinitionStatus buildable = new V1beta1CustomResourceDefinitionStatus();
        buildable.setAcceptedNames(fluent.getAcceptedNames());
        buildable.setConditions(fluent.getConditions());
        buildable.setStoredVersions(fluent.getStoredVersions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1beta1CustomResourceDefinitionStatusBuilder that = (V1beta1CustomResourceDefinitionStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
