package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1beta1CustomResourceDefinitionSpecFluentImpl<A extends V1beta1CustomResourceDefinitionSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CustomResourceDefinitionSpecFluent<A> {

    private List<V1beta1CustomResourceColumnDefinitionBuilder> additionalPrinterColumns;
    private V1beta1CustomResourceConversionBuilder conversion;
    private String group;
    private V1beta1CustomResourceDefinitionNamesBuilder names;
    private Boolean preserveUnknownFields;
    private String scope;
    private V1beta1CustomResourceSubresourcesBuilder subresources;
    private V1beta1CustomResourceValidationBuilder validation;
    private String version;
    private List<V1beta1CustomResourceDefinitionVersionBuilder> versions;

    public V1beta1CustomResourceDefinitionSpecFluentImpl() { 
    }


    public V1beta1CustomResourceDefinitionSpecFluentImpl(V1beta1CustomResourceDefinitionSpec instance) { 
        this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns());

        this.withConversion(instance.getConversion());

        this.withGroup(instance.getGroup());

        this.withNames(instance.getNames());

        this.withPreserveUnknownFields(instance.getPreserveUnknownFields());

        this.withScope(instance.getScope());

        this.withSubresources(instance.getSubresources());

        this.withValidation(instance.getValidation());

        this.withVersion(instance.getVersion());

        this.withVersions(instance.getVersions());

    }


    public A addToAdditionalPrinterColumns(int index,V1beta1CustomResourceColumnDefinition item) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<V1beta1CustomResourceColumnDefinitionBuilder>();}
        V1beta1CustomResourceColumnDefinitionBuilder builder = new V1beta1CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(index >= 0 ? index : _visitables.get("additionalPrinterColumns").size(), builder);this.additionalPrinterColumns.add(index >= 0 ? index : additionalPrinterColumns.size(), builder); return (A)this;
    }

    public A setToAdditionalPrinterColumns(int index,V1beta1CustomResourceColumnDefinition item) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<V1beta1CustomResourceColumnDefinitionBuilder>();}
        V1beta1CustomResourceColumnDefinitionBuilder builder = new V1beta1CustomResourceColumnDefinitionBuilder(item);
        if (index < 0 || index >= _visitables.get("additionalPrinterColumns").size()) { _visitables.get("additionalPrinterColumns").add(builder); } else { _visitables.get("additionalPrinterColumns").set(index, builder);}
        if (index < 0 || index >= additionalPrinterColumns.size()) { additionalPrinterColumns.add(builder); } else { additionalPrinterColumns.set(index, builder);}
         return (A)this;
    }

    public A addToAdditionalPrinterColumns(V1beta1CustomResourceColumnDefinition... items) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<V1beta1CustomResourceColumnDefinitionBuilder>();}
        for (V1beta1CustomResourceColumnDefinition item : items) {V1beta1CustomResourceColumnDefinitionBuilder builder = new V1beta1CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
    }

    public A addAllToAdditionalPrinterColumns(Collection<V1beta1CustomResourceColumnDefinition> items) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<V1beta1CustomResourceColumnDefinitionBuilder>();}
        for (V1beta1CustomResourceColumnDefinition item : items) {V1beta1CustomResourceColumnDefinitionBuilder builder = new V1beta1CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
    }

    public A removeFromAdditionalPrinterColumns(V1beta1CustomResourceColumnDefinition... items) {
        for (V1beta1CustomResourceColumnDefinition item : items) {V1beta1CustomResourceColumnDefinitionBuilder builder = new V1beta1CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder);if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.remove(builder);}} return (A)this;
    }

    public A removeAllFromAdditionalPrinterColumns(Collection<V1beta1CustomResourceColumnDefinition> items) {
        for (V1beta1CustomResourceColumnDefinition item : items) {V1beta1CustomResourceColumnDefinitionBuilder builder = new V1beta1CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder);if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAdditionalPrinterColumns(io.kubernetes.client.fluent.Predicate<V1beta1CustomResourceColumnDefinitionBuilder> predicate) {
        if (additionalPrinterColumns == null) return (A) this;
        final Iterator<V1beta1CustomResourceColumnDefinitionBuilder> each = additionalPrinterColumns.iterator();
        final List visitables = _visitables.get("additionalPrinterColumns");
        while (each.hasNext()) {
          V1beta1CustomResourceColumnDefinitionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAdditionalPrinterColumns instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1CustomResourceColumnDefinition> getAdditionalPrinterColumns() {
        return build(additionalPrinterColumns);
    }

    public List<V1beta1CustomResourceColumnDefinition> buildAdditionalPrinterColumns() {
        return build(additionalPrinterColumns);
    }

    public V1beta1CustomResourceColumnDefinition buildAdditionalPrinterColumn(int index) {
        return this.additionalPrinterColumns.get(index).build();
    }

    public V1beta1CustomResourceColumnDefinition buildFirstAdditionalPrinterColumn() {
        return this.additionalPrinterColumns.get(0).build();
    }

    public V1beta1CustomResourceColumnDefinition buildLastAdditionalPrinterColumn() {
        return this.additionalPrinterColumns.get(additionalPrinterColumns.size() - 1).build();
    }

    public V1beta1CustomResourceColumnDefinition buildMatchingAdditionalPrinterColumn(io.kubernetes.client.fluent.Predicate<V1beta1CustomResourceColumnDefinitionBuilder> predicate) {
        for (V1beta1CustomResourceColumnDefinitionBuilder item: additionalPrinterColumns) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAdditionalPrinterColumn(io.kubernetes.client.fluent.Predicate<V1beta1CustomResourceColumnDefinitionBuilder> predicate) {
        for (V1beta1CustomResourceColumnDefinitionBuilder item: additionalPrinterColumns) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAdditionalPrinterColumns(List<V1beta1CustomResourceColumnDefinition> additionalPrinterColumns) {
        if (this.additionalPrinterColumns != null) { _visitables.get("additionalPrinterColumns").removeAll(this.additionalPrinterColumns);}
        if (additionalPrinterColumns != null) {this.additionalPrinterColumns = new ArrayList<V1beta1CustomResourceColumnDefinitionBuilder>(); for (V1beta1CustomResourceColumnDefinition item : additionalPrinterColumns){this.addToAdditionalPrinterColumns(item);}} else { this.additionalPrinterColumns = null;} return (A) this;
    }

    public A withAdditionalPrinterColumns(V1beta1CustomResourceColumnDefinition... additionalPrinterColumns) {
        if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.clear();}
        if (additionalPrinterColumns != null) {for (V1beta1CustomResourceColumnDefinition item :additionalPrinterColumns){ this.addToAdditionalPrinterColumns(item);}} return (A) this;
    }

    public Boolean hasAdditionalPrinterColumns() {
        return additionalPrinterColumns != null && !additionalPrinterColumns.isEmpty();
    }

    public V1beta1CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumn() {
        return new AdditionalPrinterColumnsNestedImpl();
    }

    public V1beta1CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumnLike(V1beta1CustomResourceColumnDefinition item) {
        return new AdditionalPrinterColumnsNestedImpl(-1, item);
    }

    public V1beta1CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> setNewAdditionalPrinterColumnLike(int index,V1beta1CustomResourceColumnDefinition item) {
        return new AdditionalPrinterColumnsNestedImpl(index, item);
    }

    public V1beta1CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editAdditionalPrinterColumn(int index) {
        if (additionalPrinterColumns.size() <= index) throw new RuntimeException("Can't edit additionalPrinterColumns. Index exceeds size.");
        return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
    }

    public V1beta1CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editFirstAdditionalPrinterColumn() {
        if (additionalPrinterColumns.size() == 0) throw new RuntimeException("Can't edit first additionalPrinterColumns. The list is empty.");
        return setNewAdditionalPrinterColumnLike(0, buildAdditionalPrinterColumn(0));
    }

    public V1beta1CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editLastAdditionalPrinterColumn() {
        int index = additionalPrinterColumns.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last additionalPrinterColumns. The list is empty.");
        return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
    }

    public V1beta1CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editMatchingAdditionalPrinterColumn(io.kubernetes.client.fluent.Predicate<V1beta1CustomResourceColumnDefinitionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<additionalPrinterColumns.size();i++) { 
        if (predicate.apply(additionalPrinterColumns.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching additionalPrinterColumns. No match found.");
        return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
    }

    
/**
 * This method has been deprecated, please use method buildConversion instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1CustomResourceConversion getConversion() {
        return this.conversion!=null?this.conversion.build():null;
    }

    public V1beta1CustomResourceConversion buildConversion() {
        return this.conversion!=null?this.conversion.build():null;
    }

    public A withConversion(V1beta1CustomResourceConversion conversion) {
        _visitables.get("conversion").remove(this.conversion);
        if (conversion!=null){ this.conversion= new V1beta1CustomResourceConversionBuilder(conversion); _visitables.get("conversion").add(this.conversion);} return (A) this;
    }

    public Boolean hasConversion() {
        return this.conversion != null;
    }

    public V1beta1CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversion() {
        return new ConversionNestedImpl();
    }

    public V1beta1CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversionLike(V1beta1CustomResourceConversion item) {
        return new ConversionNestedImpl(item);
    }

    public V1beta1CustomResourceDefinitionSpecFluent.ConversionNested<A> editConversion() {
        return withNewConversionLike(getConversion());
    }

    public V1beta1CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversion() {
        return withNewConversionLike(getConversion() != null ? getConversion(): new V1beta1CustomResourceConversionBuilder().build());
    }

    public V1beta1CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversionLike(V1beta1CustomResourceConversion item) {
        return withNewConversionLike(getConversion() != null ? getConversion(): item);
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group=group; return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1) {
        return (A)withGroup(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNames instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1CustomResourceDefinitionNames getNames() {
        return this.names!=null?this.names.build():null;
    }

    public V1beta1CustomResourceDefinitionNames buildNames() {
        return this.names!=null?this.names.build():null;
    }

    public A withNames(V1beta1CustomResourceDefinitionNames names) {
        _visitables.get("names").remove(this.names);
        if (names!=null){ this.names= new V1beta1CustomResourceDefinitionNamesBuilder(names); _visitables.get("names").add(this.names);} return (A) this;
    }

    public Boolean hasNames() {
        return this.names != null;
    }

    public V1beta1CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNames() {
        return new NamesNestedImpl();
    }

    public V1beta1CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNamesLike(V1beta1CustomResourceDefinitionNames item) {
        return new NamesNestedImpl(item);
    }

    public V1beta1CustomResourceDefinitionSpecFluent.NamesNested<A> editNames() {
        return withNewNamesLike(getNames());
    }

    public V1beta1CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNames() {
        return withNewNamesLike(getNames() != null ? getNames(): new V1beta1CustomResourceDefinitionNamesBuilder().build());
    }

    public V1beta1CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNamesLike(V1beta1CustomResourceDefinitionNames item) {
        return withNewNamesLike(getNames() != null ? getNames(): item);
    }

    public Boolean isPreserveUnknownFields() {
        return this.preserveUnknownFields;
    }

    public A withPreserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields=preserveUnknownFields; return (A) this;
    }

    public Boolean hasPreserveUnknownFields() {
        return this.preserveUnknownFields != null;
    }

    public A withNewPreserveUnknownFields(String arg1) {
        return (A)withPreserveUnknownFields(new Boolean(arg1));
    }

    public A withNewPreserveUnknownFields(boolean arg1) {
        return (A)withPreserveUnknownFields(new Boolean(arg1));
    }

    public String getScope() {
        return this.scope;
    }

    public A withScope(String scope) {
        this.scope=scope; return (A) this;
    }

    public Boolean hasScope() {
        return this.scope != null;
    }

    public A withNewScope(String arg1) {
        return (A)withScope(new String(arg1));
    }

    public A withNewScope(StringBuilder arg1) {
        return (A)withScope(new String(arg1));
    }

    public A withNewScope(StringBuffer arg1) {
        return (A)withScope(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSubresources instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1CustomResourceSubresources getSubresources() {
        return this.subresources!=null?this.subresources.build():null;
    }

    public V1beta1CustomResourceSubresources buildSubresources() {
        return this.subresources!=null?this.subresources.build():null;
    }

    public A withSubresources(V1beta1CustomResourceSubresources subresources) {
        _visitables.get("subresources").remove(this.subresources);
        if (subresources!=null){ this.subresources= new V1beta1CustomResourceSubresourcesBuilder(subresources); _visitables.get("subresources").add(this.subresources);} return (A) this;
    }

    public Boolean hasSubresources() {
        return this.subresources != null;
    }

    public V1beta1CustomResourceDefinitionSpecFluent.SubresourcesNested<A> withNewSubresources() {
        return new SubresourcesNestedImpl();
    }

    public V1beta1CustomResourceDefinitionSpecFluent.SubresourcesNested<A> withNewSubresourcesLike(V1beta1CustomResourceSubresources item) {
        return new SubresourcesNestedImpl(item);
    }

    public V1beta1CustomResourceDefinitionSpecFluent.SubresourcesNested<A> editSubresources() {
        return withNewSubresourcesLike(getSubresources());
    }

    public V1beta1CustomResourceDefinitionSpecFluent.SubresourcesNested<A> editOrNewSubresources() {
        return withNewSubresourcesLike(getSubresources() != null ? getSubresources(): new V1beta1CustomResourceSubresourcesBuilder().build());
    }

    public V1beta1CustomResourceDefinitionSpecFluent.SubresourcesNested<A> editOrNewSubresourcesLike(V1beta1CustomResourceSubresources item) {
        return withNewSubresourcesLike(getSubresources() != null ? getSubresources(): item);
    }

    
/**
 * This method has been deprecated, please use method buildValidation instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1CustomResourceValidation getValidation() {
        return this.validation!=null?this.validation.build():null;
    }

    public V1beta1CustomResourceValidation buildValidation() {
        return this.validation!=null?this.validation.build():null;
    }

    public A withValidation(V1beta1CustomResourceValidation validation) {
        _visitables.get("validation").remove(this.validation);
        if (validation!=null){ this.validation= new V1beta1CustomResourceValidationBuilder(validation); _visitables.get("validation").add(this.validation);} return (A) this;
    }

    public Boolean hasValidation() {
        return this.validation != null;
    }

    public V1beta1CustomResourceDefinitionSpecFluent.ValidationNested<A> withNewValidation() {
        return new ValidationNestedImpl();
    }

    public V1beta1CustomResourceDefinitionSpecFluent.ValidationNested<A> withNewValidationLike(V1beta1CustomResourceValidation item) {
        return new ValidationNestedImpl(item);
    }

    public V1beta1CustomResourceDefinitionSpecFluent.ValidationNested<A> editValidation() {
        return withNewValidationLike(getValidation());
    }

    public V1beta1CustomResourceDefinitionSpecFluent.ValidationNested<A> editOrNewValidation() {
        return withNewValidationLike(getValidation() != null ? getValidation(): new V1beta1CustomResourceValidationBuilder().build());
    }

    public V1beta1CustomResourceDefinitionSpecFluent.ValidationNested<A> editOrNewValidationLike(V1beta1CustomResourceValidation item) {
        return withNewValidationLike(getValidation() != null ? getValidation(): item);
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A addToVersions(int index,V1beta1CustomResourceDefinitionVersion item) {
        if (this.versions == null) {this.versions = new ArrayList<V1beta1CustomResourceDefinitionVersionBuilder>();}
        V1beta1CustomResourceDefinitionVersionBuilder builder = new V1beta1CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
    }

    public A setToVersions(int index,V1beta1CustomResourceDefinitionVersion item) {
        if (this.versions == null) {this.versions = new ArrayList<V1beta1CustomResourceDefinitionVersionBuilder>();}
        V1beta1CustomResourceDefinitionVersionBuilder builder = new V1beta1CustomResourceDefinitionVersionBuilder(item);
        if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
        if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
         return (A)this;
    }

    public A addToVersions(V1beta1CustomResourceDefinitionVersion... items) {
        if (this.versions == null) {this.versions = new ArrayList<V1beta1CustomResourceDefinitionVersionBuilder>();}
        for (V1beta1CustomResourceDefinitionVersion item : items) {V1beta1CustomResourceDefinitionVersionBuilder builder = new V1beta1CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
    }

    public A addAllToVersions(Collection<V1beta1CustomResourceDefinitionVersion> items) {
        if (this.versions == null) {this.versions = new ArrayList<V1beta1CustomResourceDefinitionVersionBuilder>();}
        for (V1beta1CustomResourceDefinitionVersion item : items) {V1beta1CustomResourceDefinitionVersionBuilder builder = new V1beta1CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
    }

    public A removeFromVersions(V1beta1CustomResourceDefinitionVersion... items) {
        for (V1beta1CustomResourceDefinitionVersion item : items) {V1beta1CustomResourceDefinitionVersionBuilder builder = new V1beta1CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
    }

    public A removeAllFromVersions(Collection<V1beta1CustomResourceDefinitionVersion> items) {
        for (V1beta1CustomResourceDefinitionVersion item : items) {V1beta1CustomResourceDefinitionVersionBuilder builder = new V1beta1CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVersions(io.kubernetes.client.fluent.Predicate<V1beta1CustomResourceDefinitionVersionBuilder> predicate) {
        if (versions == null) return (A) this;
        final Iterator<V1beta1CustomResourceDefinitionVersionBuilder> each = versions.iterator();
        final List visitables = _visitables.get("versions");
        while (each.hasNext()) {
          V1beta1CustomResourceDefinitionVersionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVersions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1CustomResourceDefinitionVersion> getVersions() {
        return build(versions);
    }

    public List<V1beta1CustomResourceDefinitionVersion> buildVersions() {
        return build(versions);
    }

    public V1beta1CustomResourceDefinitionVersion buildVersion(int index) {
        return this.versions.get(index).build();
    }

    public V1beta1CustomResourceDefinitionVersion buildFirstVersion() {
        return this.versions.get(0).build();
    }

    public V1beta1CustomResourceDefinitionVersion buildLastVersion() {
        return this.versions.get(versions.size() - 1).build();
    }

    public V1beta1CustomResourceDefinitionVersion buildMatchingVersion(io.kubernetes.client.fluent.Predicate<V1beta1CustomResourceDefinitionVersionBuilder> predicate) {
        for (V1beta1CustomResourceDefinitionVersionBuilder item: versions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVersion(io.kubernetes.client.fluent.Predicate<V1beta1CustomResourceDefinitionVersionBuilder> predicate) {
        for (V1beta1CustomResourceDefinitionVersionBuilder item: versions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVersions(List<V1beta1CustomResourceDefinitionVersion> versions) {
        if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
        if (versions != null) {this.versions = new ArrayList<V1beta1CustomResourceDefinitionVersionBuilder>(); for (V1beta1CustomResourceDefinitionVersion item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
    }

    public A withVersions(V1beta1CustomResourceDefinitionVersion... versions) {
        if (this.versions != null) {this.versions.clear();}
        if (versions != null) {for (V1beta1CustomResourceDefinitionVersion item :versions){ this.addToVersions(item);}} return (A) this;
    }

    public Boolean hasVersions() {
        return versions != null && !versions.isEmpty();
    }

    public V1beta1CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersion() {
        return new VersionsNestedImpl();
    }

    public V1beta1CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersionLike(V1beta1CustomResourceDefinitionVersion item) {
        return new VersionsNestedImpl(-1, item);
    }

    public V1beta1CustomResourceDefinitionSpecFluent.VersionsNested<A> setNewVersionLike(int index,V1beta1CustomResourceDefinitionVersion item) {
        return new VersionsNestedImpl(index, item);
    }

    public V1beta1CustomResourceDefinitionSpecFluent.VersionsNested<A> editVersion(int index) {
        if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public V1beta1CustomResourceDefinitionSpecFluent.VersionsNested<A> editFirstVersion() {
        if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
        return setNewVersionLike(0, buildVersion(0));
    }

    public V1beta1CustomResourceDefinitionSpecFluent.VersionsNested<A> editLastVersion() {
        int index = versions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public V1beta1CustomResourceDefinitionSpecFluent.VersionsNested<A> editMatchingVersion(io.kubernetes.client.fluent.Predicate<V1beta1CustomResourceDefinitionVersionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<versions.size();i++) { 
        if (predicate.apply(versions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1beta1CustomResourceDefinitionSpecFluentImpl that = (V1beta1CustomResourceDefinitionSpecFluentImpl) o;
        if (additionalPrinterColumns != null ? !additionalPrinterColumns.equals(that.additionalPrinterColumns) :that.additionalPrinterColumns != null) return false;
        if (conversion != null ? !conversion.equals(that.conversion) :that.conversion != null) return false;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (names != null ? !names.equals(that.names) :that.names != null) return false;
        if (preserveUnknownFields != null ? !preserveUnknownFields.equals(that.preserveUnknownFields) :that.preserveUnknownFields != null) return false;
        if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
        if (subresources != null ? !subresources.equals(that.subresources) :that.subresources != null) return false;
        if (validation != null ? !validation.equals(that.validation) :that.validation != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(additionalPrinterColumns,  conversion,  group,  names,  preserveUnknownFields,  scope,  subresources,  validation,  version,  versions,  super.hashCode());
    }

    public class AdditionalPrinterColumnsNestedImpl<N> extends V1beta1CustomResourceColumnDefinitionFluentImpl<V1beta1CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<N>> implements V1beta1CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1CustomResourceColumnDefinitionBuilder builder;
        private final int index;

        AdditionalPrinterColumnsNestedImpl(int index,V1beta1CustomResourceColumnDefinition item) {
            this.index = index;
            this.builder = new V1beta1CustomResourceColumnDefinitionBuilder(this, item);
        }

        AdditionalPrinterColumnsNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1CustomResourceColumnDefinitionBuilder(this);
        }

        public N and() {
             return (N) V1beta1CustomResourceDefinitionSpecFluentImpl.this.setToAdditionalPrinterColumns(index,builder.build());
        }

        public N endAdditionalPrinterColumn() {
             return and();
        }
    }


    public class ConversionNestedImpl<N> extends V1beta1CustomResourceConversionFluentImpl<V1beta1CustomResourceDefinitionSpecFluent.ConversionNested<N>> implements V1beta1CustomResourceDefinitionSpecFluent.ConversionNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1CustomResourceConversionBuilder builder;

        ConversionNestedImpl(V1beta1CustomResourceConversion item) {
            this.builder = new V1beta1CustomResourceConversionBuilder(this, item);
        }

        ConversionNestedImpl() {
            this.builder = new V1beta1CustomResourceConversionBuilder(this);
        }

        public N and() {
             return (N) V1beta1CustomResourceDefinitionSpecFluentImpl.this.withConversion(builder.build());
        }

        public N endConversion() {
             return and();
        }
    }


    public class NamesNestedImpl<N> extends V1beta1CustomResourceDefinitionNamesFluentImpl<V1beta1CustomResourceDefinitionSpecFluent.NamesNested<N>> implements V1beta1CustomResourceDefinitionSpecFluent.NamesNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1CustomResourceDefinitionNamesBuilder builder;

        NamesNestedImpl(V1beta1CustomResourceDefinitionNames item) {
            this.builder = new V1beta1CustomResourceDefinitionNamesBuilder(this, item);
        }

        NamesNestedImpl() {
            this.builder = new V1beta1CustomResourceDefinitionNamesBuilder(this);
        }

        public N and() {
             return (N) V1beta1CustomResourceDefinitionSpecFluentImpl.this.withNames(builder.build());
        }

        public N endNames() {
             return and();
        }
    }


    public class SubresourcesNestedImpl<N> extends V1beta1CustomResourceSubresourcesFluentImpl<V1beta1CustomResourceDefinitionSpecFluent.SubresourcesNested<N>> implements V1beta1CustomResourceDefinitionSpecFluent.SubresourcesNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1CustomResourceSubresourcesBuilder builder;

        SubresourcesNestedImpl(V1beta1CustomResourceSubresources item) {
            this.builder = new V1beta1CustomResourceSubresourcesBuilder(this, item);
        }

        SubresourcesNestedImpl() {
            this.builder = new V1beta1CustomResourceSubresourcesBuilder(this);
        }

        public N and() {
             return (N) V1beta1CustomResourceDefinitionSpecFluentImpl.this.withSubresources(builder.build());
        }

        public N endSubresources() {
             return and();
        }
    }


    public class ValidationNestedImpl<N> extends V1beta1CustomResourceValidationFluentImpl<V1beta1CustomResourceDefinitionSpecFluent.ValidationNested<N>> implements V1beta1CustomResourceDefinitionSpecFluent.ValidationNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1CustomResourceValidationBuilder builder;

        ValidationNestedImpl(V1beta1CustomResourceValidation item) {
            this.builder = new V1beta1CustomResourceValidationBuilder(this, item);
        }

        ValidationNestedImpl() {
            this.builder = new V1beta1CustomResourceValidationBuilder(this);
        }

        public N and() {
             return (N) V1beta1CustomResourceDefinitionSpecFluentImpl.this.withValidation(builder.build());
        }

        public N endValidation() {
             return and();
        }
    }


    public class VersionsNestedImpl<N> extends V1beta1CustomResourceDefinitionVersionFluentImpl<V1beta1CustomResourceDefinitionSpecFluent.VersionsNested<N>> implements V1beta1CustomResourceDefinitionSpecFluent.VersionsNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1CustomResourceDefinitionVersionBuilder builder;
        private final int index;

        VersionsNestedImpl(int index,V1beta1CustomResourceDefinitionVersion item) {
            this.index = index;
            this.builder = new V1beta1CustomResourceDefinitionVersionBuilder(this, item);
        }

        VersionsNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1CustomResourceDefinitionVersionBuilder(this);
        }

        public N and() {
             return (N) V1beta1CustomResourceDefinitionSpecFluentImpl.this.setToVersions(index,builder.build());
        }

        public N endVersion() {
             return and();
        }
    }


}
