package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta1APIServiceStatusFluentImpl<A extends V1beta1APIServiceStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1APIServiceStatusFluent<A> {

    private List<V1beta1APIServiceConditionBuilder> conditions;

    public V1beta1APIServiceStatusFluentImpl() { 
    }


    public V1beta1APIServiceStatusFluentImpl(V1beta1APIServiceStatus instance) { 
        this.withConditions(instance.getConditions());

    }


    public A addToConditions(int index,V1beta1APIServiceCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1beta1APIServiceConditionBuilder>();}
        V1beta1APIServiceConditionBuilder builder = new V1beta1APIServiceConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1beta1APIServiceCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1beta1APIServiceConditionBuilder>();}
        V1beta1APIServiceConditionBuilder builder = new V1beta1APIServiceConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(V1beta1APIServiceCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1beta1APIServiceConditionBuilder>();}
        for (V1beta1APIServiceCondition item : items) {V1beta1APIServiceConditionBuilder builder = new V1beta1APIServiceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1beta1APIServiceCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1beta1APIServiceConditionBuilder>();}
        for (V1beta1APIServiceCondition item : items) {V1beta1APIServiceConditionBuilder builder = new V1beta1APIServiceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1beta1APIServiceCondition... items) {
        for (V1beta1APIServiceCondition item : items) {V1beta1APIServiceConditionBuilder builder = new V1beta1APIServiceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1beta1APIServiceCondition> items) {
        for (V1beta1APIServiceCondition item : items) {V1beta1APIServiceConditionBuilder builder = new V1beta1APIServiceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<V1beta1APIServiceConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<V1beta1APIServiceConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          V1beta1APIServiceConditionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1APIServiceCondition> getConditions() {
        return build(conditions);
    }

    public List<V1beta1APIServiceCondition> buildConditions() {
        return build(conditions);
    }

    public V1beta1APIServiceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1beta1APIServiceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1beta1APIServiceCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public V1beta1APIServiceCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1APIServiceConditionBuilder> predicate) {
        for (V1beta1APIServiceConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1APIServiceConditionBuilder> predicate) {
        for (V1beta1APIServiceConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<V1beta1APIServiceCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<V1beta1APIServiceConditionBuilder>(); for (V1beta1APIServiceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1beta1APIServiceCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (V1beta1APIServiceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public V1beta1APIServiceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public V1beta1APIServiceStatusFluent.ConditionsNested<A> addNewConditionLike(V1beta1APIServiceCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public V1beta1APIServiceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1beta1APIServiceCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public V1beta1APIServiceStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public V1beta1APIServiceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public V1beta1APIServiceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public V1beta1APIServiceStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1APIServiceConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.apply(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1beta1APIServiceStatusFluentImpl that = (V1beta1APIServiceStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends V1beta1APIServiceConditionFluentImpl<V1beta1APIServiceStatusFluent.ConditionsNested<N>> implements V1beta1APIServiceStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1APIServiceConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,V1beta1APIServiceCondition item) {
            this.index = index;
            this.builder = new V1beta1APIServiceConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1APIServiceConditionBuilder(this);
        }

        public N and() {
             return (N) V1beta1APIServiceStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


}
