package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PriorityLevelConfigurationStatusBuilder extends V1alpha1PriorityLevelConfigurationStatusFluentImpl<V1alpha1PriorityLevelConfigurationStatusBuilder> implements VisitableBuilder<V1alpha1PriorityLevelConfigurationStatus,V1alpha1PriorityLevelConfigurationStatusBuilder> {

    V1alpha1PriorityLevelConfigurationStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PriorityLevelConfigurationStatusBuilder() { 
        this(true);
    }


    public V1alpha1PriorityLevelConfigurationStatusBuilder(Boolean validationEnabled) { 
        this(new V1alpha1PriorityLevelConfigurationStatus(), validationEnabled);
    }


    public V1alpha1PriorityLevelConfigurationStatusBuilder(V1alpha1PriorityLevelConfigurationStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1alpha1PriorityLevelConfigurationStatusBuilder(V1alpha1PriorityLevelConfigurationStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1alpha1PriorityLevelConfigurationStatus(), validationEnabled);
    }


    public V1alpha1PriorityLevelConfigurationStatusBuilder(V1alpha1PriorityLevelConfigurationStatusFluent<?> fluent,V1alpha1PriorityLevelConfigurationStatus instance) { 
        this(fluent, instance, true);
    }


    public V1alpha1PriorityLevelConfigurationStatusBuilder(V1alpha1PriorityLevelConfigurationStatusFluent<?> fluent,V1alpha1PriorityLevelConfigurationStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions());

        this.validationEnabled = validationEnabled; 
    }


    public V1alpha1PriorityLevelConfigurationStatusBuilder(V1alpha1PriorityLevelConfigurationStatus instance) { 
        this(instance,true);
    }


    public V1alpha1PriorityLevelConfigurationStatusBuilder(V1alpha1PriorityLevelConfigurationStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withConditions(instance.getConditions());

        this.validationEnabled = validationEnabled; 
    }


    public V1alpha1PriorityLevelConfigurationStatus build() {
        V1alpha1PriorityLevelConfigurationStatus buildable = new V1alpha1PriorityLevelConfigurationStatus();
        buildable.setConditions(fluent.getConditions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1alpha1PriorityLevelConfigurationStatusBuilder that = (V1alpha1PriorityLevelConfigurationStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
