package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1WindowsSecurityContextOptionsBuilder extends V1WindowsSecurityContextOptionsFluentImpl<V1WindowsSecurityContextOptionsBuilder> implements VisitableBuilder<V1WindowsSecurityContextOptions,V1WindowsSecurityContextOptionsBuilder> {

    V1WindowsSecurityContextOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1WindowsSecurityContextOptionsBuilder() { 
        this(true);
    }


    public V1WindowsSecurityContextOptionsBuilder(Boolean validationEnabled) { 
        this(new V1WindowsSecurityContextOptions(), validationEnabled);
    }


    public V1WindowsSecurityContextOptionsBuilder(V1WindowsSecurityContextOptionsFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1WindowsSecurityContextOptionsBuilder(V1WindowsSecurityContextOptionsFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1WindowsSecurityContextOptions(), validationEnabled);
    }


    public V1WindowsSecurityContextOptionsBuilder(V1WindowsSecurityContextOptionsFluent<?> fluent,V1WindowsSecurityContextOptions instance) { 
        this(fluent, instance, true);
    }


    public V1WindowsSecurityContextOptionsBuilder(V1WindowsSecurityContextOptionsFluent<?> fluent,V1WindowsSecurityContextOptions instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withGmsaCredentialSpec(instance.getGmsaCredentialSpec());

        fluent.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName());

        fluent.withRunAsUserName(instance.getRunAsUserName());

        this.validationEnabled = validationEnabled; 
    }


    public V1WindowsSecurityContextOptionsBuilder(V1WindowsSecurityContextOptions instance) { 
        this(instance,true);
    }


    public V1WindowsSecurityContextOptionsBuilder(V1WindowsSecurityContextOptions instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withGmsaCredentialSpec(instance.getGmsaCredentialSpec());

        this.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName());

        this.withRunAsUserName(instance.getRunAsUserName());

        this.validationEnabled = validationEnabled; 
    }


    public V1WindowsSecurityContextOptions build() {
        V1WindowsSecurityContextOptions buildable = new V1WindowsSecurityContextOptions();
        buildable.setGmsaCredentialSpec(fluent.getGmsaCredentialSpec());
        buildable.setGmsaCredentialSpecName(fluent.getGmsaCredentialSpecName());
        buildable.setRunAsUserName(fluent.getRunAsUserName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1WindowsSecurityContextOptionsBuilder that = (V1WindowsSecurityContextOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
