package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1TopologySelectorLabelRequirementBuilder extends V1TopologySelectorLabelRequirementFluentImpl<V1TopologySelectorLabelRequirementBuilder> implements VisitableBuilder<V1TopologySelectorLabelRequirement,V1TopologySelectorLabelRequirementBuilder> {

    V1TopologySelectorLabelRequirementFluent<?> fluent;
    Boolean validationEnabled;

    public V1TopologySelectorLabelRequirementBuilder() { 
        this(true);
    }


    public V1TopologySelectorLabelRequirementBuilder(Boolean validationEnabled) { 
        this(new V1TopologySelectorLabelRequirement(), validationEnabled);
    }


    public V1TopologySelectorLabelRequirementBuilder(V1TopologySelectorLabelRequirementFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1TopologySelectorLabelRequirementBuilder(V1TopologySelectorLabelRequirementFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1TopologySelectorLabelRequirement(), validationEnabled);
    }


    public V1TopologySelectorLabelRequirementBuilder(V1TopologySelectorLabelRequirementFluent<?> fluent,V1TopologySelectorLabelRequirement instance) { 
        this(fluent, instance, true);
    }


    public V1TopologySelectorLabelRequirementBuilder(V1TopologySelectorLabelRequirementFluent<?> fluent,V1TopologySelectorLabelRequirement instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withKey(instance.getKey());

        fluent.withValues(instance.getValues());

        this.validationEnabled = validationEnabled; 
    }


    public V1TopologySelectorLabelRequirementBuilder(V1TopologySelectorLabelRequirement instance) { 
        this(instance,true);
    }


    public V1TopologySelectorLabelRequirementBuilder(V1TopologySelectorLabelRequirement instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withKey(instance.getKey());

        this.withValues(instance.getValues());

        this.validationEnabled = validationEnabled; 
    }


    public V1TopologySelectorLabelRequirement build() {
        V1TopologySelectorLabelRequirement buildable = new V1TopologySelectorLabelRequirement();
        buildable.setKey(fluent.getKey());
        buildable.setValues(fluent.getValues());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1TopologySelectorLabelRequirementBuilder that = (V1TopologySelectorLabelRequirementBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
