package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class V1TokenRequestFluentImpl<A extends V1TokenRequestFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1TokenRequestFluent<A> {

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1TokenRequestSpecBuilder spec;
    private V1TokenRequestStatusBuilder status;

    public V1TokenRequestFluentImpl() { 
    }


    public V1TokenRequestFluentImpl(V1TokenRequest instance) { 
        this.withApiVersion(instance.getApiVersion());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withSpec(instance.getSpec());

        this.withStatus(instance.getStatus());

    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public V1TokenRequestFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public V1TokenRequestFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public V1TokenRequestFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public V1TokenRequestFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1TokenRequestFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1TokenRequestSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public V1TokenRequestSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V1TokenRequestSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new V1TokenRequestSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public V1TokenRequestFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public V1TokenRequestFluent.SpecNested<A> withNewSpecLike(V1TokenRequestSpec item) {
        return new SpecNestedImpl(item);
    }

    public V1TokenRequestFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public V1TokenRequestFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new V1TokenRequestSpecBuilder().build());
    }

    public V1TokenRequestFluent.SpecNested<A> editOrNewSpecLike(V1TokenRequestSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1TokenRequestStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public V1TokenRequestStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(V1TokenRequestStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new V1TokenRequestStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public V1TokenRequestFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public V1TokenRequestFluent.StatusNested<A> withNewStatusLike(V1TokenRequestStatus item) {
        return new StatusNestedImpl(item);
    }

    public V1TokenRequestFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public V1TokenRequestFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new V1TokenRequestStatusBuilder().build());
    }

    public V1TokenRequestFluent.StatusNested<A> editOrNewStatusLike(V1TokenRequestStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1TokenRequestFluentImpl that = (V1TokenRequestFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1TokenRequestFluent.MetadataNested<N>> implements V1TokenRequestFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) V1TokenRequestFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


    public class SpecNestedImpl<N> extends V1TokenRequestSpecFluentImpl<V1TokenRequestFluent.SpecNested<N>> implements V1TokenRequestFluent.SpecNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1TokenRequestSpecBuilder builder;

        SpecNestedImpl(V1TokenRequestSpec item) {
            this.builder = new V1TokenRequestSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1TokenRequestSpecBuilder(this);
        }

        public N and() {
             return (N) V1TokenRequestFluentImpl.this.withSpec(builder.build());
        }

        public N endSpec() {
             return and();
        }
    }


    public class StatusNestedImpl<N> extends V1TokenRequestStatusFluentImpl<V1TokenRequestFluent.StatusNested<N>> implements V1TokenRequestFluent.StatusNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1TokenRequestStatusBuilder builder;

        StatusNestedImpl(V1TokenRequestStatus item) {
            this.builder = new V1TokenRequestStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1TokenRequestStatusBuilder(this);
        }

        public N and() {
             return (N) V1TokenRequestFluentImpl.this.withStatus(builder.build());
        }

        public N endStatus() {
             return and();
        }
    }


}
