package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1TaintFluentImpl<A extends V1TaintFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1TaintFluent<A> {

    private String effect;
    private String key;
    private DateTime timeAdded;
    private String value;

    public V1TaintFluentImpl() { 
    }


    public V1TaintFluentImpl(V1Taint instance) { 
        this.withEffect(instance.getEffect());

        this.withKey(instance.getKey());

        this.withTimeAdded(instance.getTimeAdded());

        this.withValue(instance.getValue());

    }


    public String getEffect() {
        return this.effect;
    }

    public A withEffect(String effect) {
        this.effect=effect; return (A) this;
    }

    public Boolean hasEffect() {
        return this.effect != null;
    }

    public A withNewEffect(String arg1) {
        return (A)withEffect(new String(arg1));
    }

    public A withNewEffect(StringBuilder arg1) {
        return (A)withEffect(new String(arg1));
    }

    public A withNewEffect(StringBuffer arg1) {
        return (A)withEffect(new String(arg1));
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key=key; return (A) this;
    }

    public Boolean hasKey() {
        return this.key != null;
    }

    public A withNewKey(String arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(StringBuilder arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(StringBuffer arg1) {
        return (A)withKey(new String(arg1));
    }

    public DateTime getTimeAdded() {
        return this.timeAdded;
    }

    public A withTimeAdded(DateTime timeAdded) {
        this.timeAdded=timeAdded; return (A) this;
    }

    public Boolean hasTimeAdded() {
        return this.timeAdded != null;
    }

    public A withNewTimeAdded(int arg0,int arg1,int arg2,int arg3,int arg4) {
        return (A)withTimeAdded(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewTimeAdded(Object arg0) {
        return (A)withTimeAdded(new DateTime(arg0));
    }

    public A withNewTimeAdded(long arg0) {
        return (A)withTimeAdded(new DateTime(arg0));
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuilder arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1) {
        return (A)withValue(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1TaintFluentImpl that = (V1TaintFluentImpl) o;
        if (effect != null ? !effect.equals(that.effect) :that.effect != null) return false;
        if (key != null ? !key.equals(that.key) :that.key != null) return false;
        if (timeAdded != null ? !timeAdded.equals(that.timeAdded) :that.timeAdded != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(effect,  key,  timeAdded,  value,  super.hashCode());
    }

}
