package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1StatusCauseBuilder extends V1StatusCauseFluentImpl<V1StatusCauseBuilder> implements VisitableBuilder<V1StatusCause,V1StatusCauseBuilder> {

    V1StatusCauseFluent<?> fluent;
    Boolean validationEnabled;

    public V1StatusCauseBuilder() { 
        this(true);
    }


    public V1StatusCauseBuilder(Boolean validationEnabled) { 
        this(new V1StatusCause(), validationEnabled);
    }


    public V1StatusCauseBuilder(V1StatusCauseFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1StatusCauseBuilder(V1StatusCauseFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1StatusCause(), validationEnabled);
    }


    public V1StatusCauseBuilder(V1StatusCauseFluent<?> fluent,V1StatusCause instance) { 
        this(fluent, instance, true);
    }


    public V1StatusCauseBuilder(V1StatusCauseFluent<?> fluent,V1StatusCause instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withField(instance.getField());

        fluent.withMessage(instance.getMessage());

        fluent.withReason(instance.getReason());

        this.validationEnabled = validationEnabled; 
    }


    public V1StatusCauseBuilder(V1StatusCause instance) { 
        this(instance,true);
    }


    public V1StatusCauseBuilder(V1StatusCause instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withField(instance.getField());

        this.withMessage(instance.getMessage());

        this.withReason(instance.getReason());

        this.validationEnabled = validationEnabled; 
    }


    public V1StatusCause build() {
        V1StatusCause buildable = new V1StatusCause();
        buildable.setField(fluent.getField());
        buildable.setMessage(fluent.getMessage());
        buildable.setReason(fluent.getReason());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1StatusCauseBuilder that = (V1StatusCauseBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
