package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;

public interface V1StatefulSetSpecFluent<A extends V1StatefulSetSpecFluent<A>> extends Fluent<A> {


    public String getPodManagementPolicy();
    public A withPodManagementPolicy(String podManagementPolicy);
    public Boolean hasPodManagementPolicy();
    public A withNewPodManagementPolicy(String arg1);
    public A withNewPodManagementPolicy(StringBuilder arg1);
    public A withNewPodManagementPolicy(StringBuffer arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public Boolean hasRevisionHistoryLimit();
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector();
    public V1LabelSelector buildSelector();
    public A withSelector(V1LabelSelector selector);
    public Boolean hasSelector();
    public V1StatefulSetSpecFluent.SelectorNested<A> withNewSelector();
    public V1StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item);
    public V1StatefulSetSpecFluent.SelectorNested<A> editSelector();
    public V1StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector();
    public V1StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item);
    public String getServiceName();
    public A withServiceName(String serviceName);
    public Boolean hasServiceName();
    public A withNewServiceName(String arg1);
    public A withNewServiceName(StringBuilder arg1);
    public A withNewServiceName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate();
    public V1PodTemplateSpec buildTemplate();
    public A withTemplate(V1PodTemplateSpec template);
    public Boolean hasTemplate();
    public V1StatefulSetSpecFluent.TemplateNested<A> withNewTemplate();
    public V1StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item);
    public V1StatefulSetSpecFluent.TemplateNested<A> editTemplate();
    public V1StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate();
    public V1StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item);
    
/**
 * This method has been deprecated, please use method buildUpdateStrategy instead.
 * @return The buildable object.
 */
@Deprecated public V1StatefulSetUpdateStrategy getUpdateStrategy();
    public V1StatefulSetUpdateStrategy buildUpdateStrategy();
    public A withUpdateStrategy(V1StatefulSetUpdateStrategy updateStrategy);
    public Boolean hasUpdateStrategy();
    public V1StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy();
    public V1StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(V1StatefulSetUpdateStrategy item);
    public V1StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy();
    public V1StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy();
    public V1StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(V1StatefulSetUpdateStrategy item);
    public A addToVolumeClaimTemplates(int index,V1PersistentVolumeClaim item);
    public A setToVolumeClaimTemplates(int index,V1PersistentVolumeClaim item);
    public A addToVolumeClaimTemplates(V1PersistentVolumeClaim... items);
    public A addAllToVolumeClaimTemplates(Collection<V1PersistentVolumeClaim> items);
    public A removeFromVolumeClaimTemplates(V1PersistentVolumeClaim... items);
    public A removeAllFromVolumeClaimTemplates(Collection<V1PersistentVolumeClaim> items);
    public A removeMatchingFromVolumeClaimTemplates(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumeClaimTemplates instead.
 * @return The buildable object.
 */
@Deprecated public List<V1PersistentVolumeClaim> getVolumeClaimTemplates();
    public List<V1PersistentVolumeClaim> buildVolumeClaimTemplates();
    public V1PersistentVolumeClaim buildVolumeClaimTemplate(int index);
    public V1PersistentVolumeClaim buildFirstVolumeClaimTemplate();
    public V1PersistentVolumeClaim buildLastVolumeClaimTemplate();
    public V1PersistentVolumeClaim buildMatchingVolumeClaimTemplate(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimBuilder> predicate);
    public Boolean hasMatchingVolumeClaimTemplate(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimBuilder> predicate);
    public A withVolumeClaimTemplates(List<V1PersistentVolumeClaim> volumeClaimTemplates);
    public A withVolumeClaimTemplates(V1PersistentVolumeClaim... volumeClaimTemplates);
    public Boolean hasVolumeClaimTemplates();
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate();
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(V1PersistentVolumeClaim item);
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index,V1PersistentVolumeClaim item);
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index);
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate();
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate();
    public V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimBuilder> predicate);
    public interface SelectorNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LabelSelectorFluent<V1StatefulSetSpecFluent.SelectorNested<N>> {

        public N and();
        public N endSelector();    }


    public interface TemplateNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodTemplateSpecFluent<V1StatefulSetSpecFluent.TemplateNested<N>> {

        public N and();
        public N endTemplate();    }


    public interface UpdateStrategyNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1StatefulSetUpdateStrategyFluent<V1StatefulSetSpecFluent.UpdateStrategyNested<N>> {

        public N and();
        public N endUpdateStrategy();    }


    public interface VolumeClaimTemplatesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PersistentVolumeClaimFluent<V1StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>> {

        public N and();
        public N endVolumeClaimTemplate();    }


}
