package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ServiceStatusBuilder extends V1ServiceStatusFluentImpl<V1ServiceStatusBuilder> implements VisitableBuilder<V1ServiceStatus,V1ServiceStatusBuilder> {

    V1ServiceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServiceStatusBuilder() { 
        this(true);
    }


    public V1ServiceStatusBuilder(Boolean validationEnabled) { 
        this(new V1ServiceStatus(), validationEnabled);
    }


    public V1ServiceStatusBuilder(V1ServiceStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1ServiceStatusBuilder(V1ServiceStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1ServiceStatus(), validationEnabled);
    }


    public V1ServiceStatusBuilder(V1ServiceStatusFluent<?> fluent,V1ServiceStatus instance) { 
        this(fluent, instance, true);
    }


    public V1ServiceStatusBuilder(V1ServiceStatusFluent<?> fluent,V1ServiceStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withLoadBalancer(instance.getLoadBalancer());

        this.validationEnabled = validationEnabled; 
    }


    public V1ServiceStatusBuilder(V1ServiceStatus instance) { 
        this(instance,true);
    }


    public V1ServiceStatusBuilder(V1ServiceStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withLoadBalancer(instance.getLoadBalancer());

        this.validationEnabled = validationEnabled; 
    }


    public V1ServiceStatus build() {
        V1ServiceStatus buildable = new V1ServiceStatus();
        buildable.setLoadBalancer(fluent.getLoadBalancer());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1ServiceStatusBuilder that = (V1ServiceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
