package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1SecretProjectionBuilder extends V1SecretProjectionFluentImpl<V1SecretProjectionBuilder> implements VisitableBuilder<V1SecretProjection,V1SecretProjectionBuilder> {

    V1SecretProjectionFluent<?> fluent;
    Boolean validationEnabled;

    public V1SecretProjectionBuilder() { 
        this(true);
    }


    public V1SecretProjectionBuilder(Boolean validationEnabled) { 
        this(new V1SecretProjection(), validationEnabled);
    }


    public V1SecretProjectionBuilder(V1SecretProjectionFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1SecretProjectionBuilder(V1SecretProjectionFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1SecretProjection(), validationEnabled);
    }


    public V1SecretProjectionBuilder(V1SecretProjectionFluent<?> fluent,V1SecretProjection instance) { 
        this(fluent, instance, true);
    }


    public V1SecretProjectionBuilder(V1SecretProjectionFluent<?> fluent,V1SecretProjection instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withItems(instance.getItems());

        fluent.withName(instance.getName());

        fluent.withOptional(instance.getOptional());

        this.validationEnabled = validationEnabled; 
    }


    public V1SecretProjectionBuilder(V1SecretProjection instance) { 
        this(instance,true);
    }


    public V1SecretProjectionBuilder(V1SecretProjection instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withItems(instance.getItems());

        this.withName(instance.getName());

        this.withOptional(instance.getOptional());

        this.validationEnabled = validationEnabled; 
    }


    public V1SecretProjection build() {
        V1SecretProjection buildable = new V1SecretProjection();
        buildable.setItems(fluent.getItems());
        buildable.setName(fluent.getName());
        buildable.setOptional(fluent.isOptional());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1SecretProjectionBuilder that = (V1SecretProjectionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
