package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1SecretEnvSourceBuilder extends V1SecretEnvSourceFluentImpl<V1SecretEnvSourceBuilder> implements VisitableBuilder<V1SecretEnvSource,V1SecretEnvSourceBuilder> {

    V1SecretEnvSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1SecretEnvSourceBuilder() { 
        this(true);
    }


    public V1SecretEnvSourceBuilder(Boolean validationEnabled) { 
        this(new V1SecretEnvSource(), validationEnabled);
    }


    public V1SecretEnvSourceBuilder(V1SecretEnvSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1SecretEnvSourceBuilder(V1SecretEnvSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1SecretEnvSource(), validationEnabled);
    }


    public V1SecretEnvSourceBuilder(V1SecretEnvSourceFluent<?> fluent,V1SecretEnvSource instance) { 
        this(fluent, instance, true);
    }


    public V1SecretEnvSourceBuilder(V1SecretEnvSourceFluent<?> fluent,V1SecretEnvSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName());

        fluent.withOptional(instance.getOptional());

        this.validationEnabled = validationEnabled; 
    }


    public V1SecretEnvSourceBuilder(V1SecretEnvSource instance) { 
        this(instance,true);
    }


    public V1SecretEnvSourceBuilder(V1SecretEnvSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName());

        this.withOptional(instance.getOptional());

        this.validationEnabled = validationEnabled; 
    }


    public V1SecretEnvSource build() {
        V1SecretEnvSource buildable = new V1SecretEnvSource();
        buildable.setName(fluent.getName());
        buildable.setOptional(fluent.isOptional());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1SecretEnvSourceBuilder that = (V1SecretEnvSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
