package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ResourceQuotaStatusBuilder extends V1ResourceQuotaStatusFluentImpl<V1ResourceQuotaStatusBuilder> implements VisitableBuilder<V1ResourceQuotaStatus,V1ResourceQuotaStatusBuilder> {

    V1ResourceQuotaStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1ResourceQuotaStatusBuilder() { 
        this(true);
    }


    public V1ResourceQuotaStatusBuilder(Boolean validationEnabled) { 
        this(new V1ResourceQuotaStatus(), validationEnabled);
    }


    public V1ResourceQuotaStatusBuilder(V1ResourceQuotaStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1ResourceQuotaStatusBuilder(V1ResourceQuotaStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1ResourceQuotaStatus(), validationEnabled);
    }


    public V1ResourceQuotaStatusBuilder(V1ResourceQuotaStatusFluent<?> fluent,V1ResourceQuotaStatus instance) { 
        this(fluent, instance, true);
    }


    public V1ResourceQuotaStatusBuilder(V1ResourceQuotaStatusFluent<?> fluent,V1ResourceQuotaStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withHard(instance.getHard());

        fluent.withUsed(instance.getUsed());

        this.validationEnabled = validationEnabled; 
    }


    public V1ResourceQuotaStatusBuilder(V1ResourceQuotaStatus instance) { 
        this(instance,true);
    }


    public V1ResourceQuotaStatusBuilder(V1ResourceQuotaStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withHard(instance.getHard());

        this.withUsed(instance.getUsed());

        this.validationEnabled = validationEnabled; 
    }


    public V1ResourceQuotaStatus build() {
        V1ResourceQuotaStatus buildable = new V1ResourceQuotaStatus();
        buildable.setHard(fluent.getHard());
        buildable.setUsed(fluent.getUsed());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1ResourceQuotaStatusBuilder that = (V1ResourceQuotaStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
