package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

public class V1ProbeFluentImpl<A extends V1ProbeFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ProbeFluent<A> {

    private V1ExecActionBuilder exec;
    private Integer failureThreshold;
    private V1HTTPGetActionBuilder httpGet;
    private Integer initialDelaySeconds;
    private Integer periodSeconds;
    private Integer successThreshold;
    private V1TCPSocketActionBuilder tcpSocket;
    private Integer timeoutSeconds;

    public V1ProbeFluentImpl() { 
    }


    public V1ProbeFluentImpl(V1Probe instance) { 
        this.withExec(instance.getExec());

        this.withFailureThreshold(instance.getFailureThreshold());

        this.withHttpGet(instance.getHttpGet());

        this.withInitialDelaySeconds(instance.getInitialDelaySeconds());

        this.withPeriodSeconds(instance.getPeriodSeconds());

        this.withSuccessThreshold(instance.getSuccessThreshold());

        this.withTcpSocket(instance.getTcpSocket());

        this.withTimeoutSeconds(instance.getTimeoutSeconds());

    }


    
/**
 * This method has been deprecated, please use method buildExec instead.
 * @return The buildable object.
 */
@Deprecated public V1ExecAction getExec() {
        return this.exec!=null?this.exec.build():null;
    }

    public V1ExecAction buildExec() {
        return this.exec!=null?this.exec.build():null;
    }

    public A withExec(V1ExecAction exec) {
        _visitables.get("exec").remove(this.exec);
        if (exec!=null){ this.exec= new V1ExecActionBuilder(exec); _visitables.get("exec").add(this.exec);} return (A) this;
    }

    public Boolean hasExec() {
        return this.exec != null;
    }

    public V1ProbeFluent.ExecNested<A> withNewExec() {
        return new ExecNestedImpl();
    }

    public V1ProbeFluent.ExecNested<A> withNewExecLike(V1ExecAction item) {
        return new ExecNestedImpl(item);
    }

    public V1ProbeFluent.ExecNested<A> editExec() {
        return withNewExecLike(getExec());
    }

    public V1ProbeFluent.ExecNested<A> editOrNewExec() {
        return withNewExecLike(getExec() != null ? getExec(): new V1ExecActionBuilder().build());
    }

    public V1ProbeFluent.ExecNested<A> editOrNewExecLike(V1ExecAction item) {
        return withNewExecLike(getExec() != null ? getExec(): item);
    }

    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public A withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold=failureThreshold; return (A) this;
    }

    public Boolean hasFailureThreshold() {
        return this.failureThreshold != null;
    }

    
/**
 * This method has been deprecated, please use method buildHttpGet instead.
 * @return The buildable object.
 */
@Deprecated public V1HTTPGetAction getHttpGet() {
        return this.httpGet!=null?this.httpGet.build():null;
    }

    public V1HTTPGetAction buildHttpGet() {
        return this.httpGet!=null?this.httpGet.build():null;
    }

    public A withHttpGet(V1HTTPGetAction httpGet) {
        _visitables.get("httpGet").remove(this.httpGet);
        if (httpGet!=null){ this.httpGet= new V1HTTPGetActionBuilder(httpGet); _visitables.get("httpGet").add(this.httpGet);} return (A) this;
    }

    public Boolean hasHttpGet() {
        return this.httpGet != null;
    }

    public V1ProbeFluent.HttpGetNested<A> withNewHttpGet() {
        return new HttpGetNestedImpl();
    }

    public V1ProbeFluent.HttpGetNested<A> withNewHttpGetLike(V1HTTPGetAction item) {
        return new HttpGetNestedImpl(item);
    }

    public V1ProbeFluent.HttpGetNested<A> editHttpGet() {
        return withNewHttpGetLike(getHttpGet());
    }

    public V1ProbeFluent.HttpGetNested<A> editOrNewHttpGet() {
        return withNewHttpGetLike(getHttpGet() != null ? getHttpGet(): new V1HTTPGetActionBuilder().build());
    }

    public V1ProbeFluent.HttpGetNested<A> editOrNewHttpGetLike(V1HTTPGetAction item) {
        return withNewHttpGetLike(getHttpGet() != null ? getHttpGet(): item);
    }

    public Integer getInitialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public A withInitialDelaySeconds(Integer initialDelaySeconds) {
        this.initialDelaySeconds=initialDelaySeconds; return (A) this;
    }

    public Boolean hasInitialDelaySeconds() {
        return this.initialDelaySeconds != null;
    }

    public Integer getPeriodSeconds() {
        return this.periodSeconds;
    }

    public A withPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds=periodSeconds; return (A) this;
    }

    public Boolean hasPeriodSeconds() {
        return this.periodSeconds != null;
    }

    public Integer getSuccessThreshold() {
        return this.successThreshold;
    }

    public A withSuccessThreshold(Integer successThreshold) {
        this.successThreshold=successThreshold; return (A) this;
    }

    public Boolean hasSuccessThreshold() {
        return this.successThreshold != null;
    }

    
/**
 * This method has been deprecated, please use method buildTcpSocket instead.
 * @return The buildable object.
 */
@Deprecated public V1TCPSocketAction getTcpSocket() {
        return this.tcpSocket!=null?this.tcpSocket.build():null;
    }

    public V1TCPSocketAction buildTcpSocket() {
        return this.tcpSocket!=null?this.tcpSocket.build():null;
    }

    public A withTcpSocket(V1TCPSocketAction tcpSocket) {
        _visitables.get("tcpSocket").remove(this.tcpSocket);
        if (tcpSocket!=null){ this.tcpSocket= new V1TCPSocketActionBuilder(tcpSocket); _visitables.get("tcpSocket").add(this.tcpSocket);} return (A) this;
    }

    public Boolean hasTcpSocket() {
        return this.tcpSocket != null;
    }

    public V1ProbeFluent.TcpSocketNested<A> withNewTcpSocket() {
        return new TcpSocketNestedImpl();
    }

    public V1ProbeFluent.TcpSocketNested<A> withNewTcpSocketLike(V1TCPSocketAction item) {
        return new TcpSocketNestedImpl(item);
    }

    public V1ProbeFluent.TcpSocketNested<A> editTcpSocket() {
        return withNewTcpSocketLike(getTcpSocket());
    }

    public V1ProbeFluent.TcpSocketNested<A> editOrNewTcpSocket() {
        return withNewTcpSocketLike(getTcpSocket() != null ? getTcpSocket(): new V1TCPSocketActionBuilder().build());
    }

    public V1ProbeFluent.TcpSocketNested<A> editOrNewTcpSocketLike(V1TCPSocketAction item) {
        return withNewTcpSocketLike(getTcpSocket() != null ? getTcpSocket(): item);
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1ProbeFluentImpl that = (V1ProbeFluentImpl) o;
        if (exec != null ? !exec.equals(that.exec) :that.exec != null) return false;
        if (failureThreshold != null ? !failureThreshold.equals(that.failureThreshold) :that.failureThreshold != null) return false;
        if (httpGet != null ? !httpGet.equals(that.httpGet) :that.httpGet != null) return false;
        if (initialDelaySeconds != null ? !initialDelaySeconds.equals(that.initialDelaySeconds) :that.initialDelaySeconds != null) return false;
        if (periodSeconds != null ? !periodSeconds.equals(that.periodSeconds) :that.periodSeconds != null) return false;
        if (successThreshold != null ? !successThreshold.equals(that.successThreshold) :that.successThreshold != null) return false;
        if (tcpSocket != null ? !tcpSocket.equals(that.tcpSocket) :that.tcpSocket != null) return false;
        if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(exec,  failureThreshold,  httpGet,  initialDelaySeconds,  periodSeconds,  successThreshold,  tcpSocket,  timeoutSeconds,  super.hashCode());
    }

    public class ExecNestedImpl<N> extends V1ExecActionFluentImpl<V1ProbeFluent.ExecNested<N>> implements V1ProbeFluent.ExecNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ExecActionBuilder builder;

        ExecNestedImpl(V1ExecAction item) {
            this.builder = new V1ExecActionBuilder(this, item);
        }

        ExecNestedImpl() {
            this.builder = new V1ExecActionBuilder(this);
        }

        public N and() {
             return (N) V1ProbeFluentImpl.this.withExec(builder.build());
        }

        public N endExec() {
             return and();
        }
    }


    public class HttpGetNestedImpl<N> extends V1HTTPGetActionFluentImpl<V1ProbeFluent.HttpGetNested<N>> implements V1ProbeFluent.HttpGetNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1HTTPGetActionBuilder builder;

        HttpGetNestedImpl(V1HTTPGetAction item) {
            this.builder = new V1HTTPGetActionBuilder(this, item);
        }

        HttpGetNestedImpl() {
            this.builder = new V1HTTPGetActionBuilder(this);
        }

        public N and() {
             return (N) V1ProbeFluentImpl.this.withHttpGet(builder.build());
        }

        public N endHttpGet() {
             return and();
        }
    }


    public class TcpSocketNestedImpl<N> extends V1TCPSocketActionFluentImpl<V1ProbeFluent.TcpSocketNested<N>> implements V1ProbeFluent.TcpSocketNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1TCPSocketActionBuilder builder;

        TcpSocketNestedImpl(V1TCPSocketAction item) {
            this.builder = new V1TCPSocketActionBuilder(this, item);
        }

        TcpSocketNestedImpl() {
            this.builder = new V1TCPSocketActionBuilder(this);
        }

        public N and() {
             return (N) V1ProbeFluentImpl.this.withTcpSocket(builder.build());
        }

        public N endTcpSocket() {
             return and();
        }
    }


}
