package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.custom.Quantity;
import java.lang.StringBuffer;
import java.util.Collection;
import java.util.Map;

public interface V1NodeStatusFluent<A extends V1NodeStatusFluent<A>> extends Fluent<A> {


    public A addToAddresses(int index,V1NodeAddress item);
    public A setToAddresses(int index,V1NodeAddress item);
    public A addToAddresses(V1NodeAddress... items);
    public A addAllToAddresses(Collection<V1NodeAddress> items);
    public A removeFromAddresses(V1NodeAddress... items);
    public A removeAllFromAddresses(Collection<V1NodeAddress> items);
    public A removeMatchingFromAddresses(io.kubernetes.client.fluent.Predicate<V1NodeAddressBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildAddresses instead.
 * @return The buildable object.
 */
@Deprecated public List<V1NodeAddress> getAddresses();
    public List<V1NodeAddress> buildAddresses();
    public V1NodeAddress buildAddress(int index);
    public V1NodeAddress buildFirstAddress();
    public V1NodeAddress buildLastAddress();
    public V1NodeAddress buildMatchingAddress(io.kubernetes.client.fluent.Predicate<V1NodeAddressBuilder> predicate);
    public Boolean hasMatchingAddress(io.kubernetes.client.fluent.Predicate<V1NodeAddressBuilder> predicate);
    public A withAddresses(List<V1NodeAddress> addresses);
    public A withAddresses(V1NodeAddress... addresses);
    public Boolean hasAddresses();
    public V1NodeStatusFluent.AddressesNested<A> addNewAddress();
    public V1NodeStatusFluent.AddressesNested<A> addNewAddressLike(V1NodeAddress item);
    public V1NodeStatusFluent.AddressesNested<A> setNewAddressLike(int index,V1NodeAddress item);
    public V1NodeStatusFluent.AddressesNested<A> editAddress(int index);
    public V1NodeStatusFluent.AddressesNested<A> editFirstAddress();
    public V1NodeStatusFluent.AddressesNested<A> editLastAddress();
    public V1NodeStatusFluent.AddressesNested<A> editMatchingAddress(io.kubernetes.client.fluent.Predicate<V1NodeAddressBuilder> predicate);
    public A addToAllocatable(String key,Quantity value);
    public A addToAllocatable(Map<String,Quantity> map);
    public A removeFromAllocatable(String key);
    public A removeFromAllocatable(Map<String,Quantity> map);
    public Map<String,Quantity> getAllocatable();
    public A withAllocatable(Map<String,Quantity> allocatable);
    public Boolean hasAllocatable();
    public A addToCapacity(String key,Quantity value);
    public A addToCapacity(Map<String,Quantity> map);
    public A removeFromCapacity(String key);
    public A removeFromCapacity(Map<String,Quantity> map);
    public Map<String,Quantity> getCapacity();
    public A withCapacity(Map<String,Quantity> capacity);
    public Boolean hasCapacity();
    public A addToConditions(int index,V1NodeCondition item);
    public A setToConditions(int index,V1NodeCondition item);
    public A addToConditions(V1NodeCondition... items);
    public A addAllToConditions(Collection<V1NodeCondition> items);
    public A removeFromConditions(V1NodeCondition... items);
    public A removeAllFromConditions(Collection<V1NodeCondition> items);
    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<V1NodeConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1NodeCondition> getConditions();
    public List<V1NodeCondition> buildConditions();
    public V1NodeCondition buildCondition(int index);
    public V1NodeCondition buildFirstCondition();
    public V1NodeCondition buildLastCondition();
    public V1NodeCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1NodeConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1NodeConditionBuilder> predicate);
    public A withConditions(List<V1NodeCondition> conditions);
    public A withConditions(V1NodeCondition... conditions);
    public Boolean hasConditions();
    public V1NodeStatusFluent.ConditionsNested<A> addNewCondition();
    public V1NodeStatusFluent.ConditionsNested<A> addNewConditionLike(V1NodeCondition item);
    public V1NodeStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1NodeCondition item);
    public V1NodeStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1NodeStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1NodeStatusFluent.ConditionsNested<A> editLastCondition();
    public V1NodeStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1NodeConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConfig instead.
 * @return The buildable object.
 */
@Deprecated public V1NodeConfigStatus getConfig();
    public V1NodeConfigStatus buildConfig();
    public A withConfig(V1NodeConfigStatus config);
    public Boolean hasConfig();
    public V1NodeStatusFluent.ConfigNested<A> withNewConfig();
    public V1NodeStatusFluent.ConfigNested<A> withNewConfigLike(V1NodeConfigStatus item);
    public V1NodeStatusFluent.ConfigNested<A> editConfig();
    public V1NodeStatusFluent.ConfigNested<A> editOrNewConfig();
    public V1NodeStatusFluent.ConfigNested<A> editOrNewConfigLike(V1NodeConfigStatus item);
    
/**
 * This method has been deprecated, please use method buildDaemonEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public V1NodeDaemonEndpoints getDaemonEndpoints();
    public V1NodeDaemonEndpoints buildDaemonEndpoints();
    public A withDaemonEndpoints(V1NodeDaemonEndpoints daemonEndpoints);
    public Boolean hasDaemonEndpoints();
    public V1NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpoints();
    public V1NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpointsLike(V1NodeDaemonEndpoints item);
    public V1NodeStatusFluent.DaemonEndpointsNested<A> editDaemonEndpoints();
    public V1NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpoints();
    public V1NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(V1NodeDaemonEndpoints item);
    public A addToImages(int index,V1ContainerImage item);
    public A setToImages(int index,V1ContainerImage item);
    public A addToImages(V1ContainerImage... items);
    public A addAllToImages(Collection<V1ContainerImage> items);
    public A removeFromImages(V1ContainerImage... items);
    public A removeAllFromImages(Collection<V1ContainerImage> items);
    public A removeMatchingFromImages(io.kubernetes.client.fluent.Predicate<V1ContainerImageBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildImages instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ContainerImage> getImages();
    public List<V1ContainerImage> buildImages();
    public V1ContainerImage buildImage(int index);
    public V1ContainerImage buildFirstImage();
    public V1ContainerImage buildLastImage();
    public V1ContainerImage buildMatchingImage(io.kubernetes.client.fluent.Predicate<V1ContainerImageBuilder> predicate);
    public Boolean hasMatchingImage(io.kubernetes.client.fluent.Predicate<V1ContainerImageBuilder> predicate);
    public A withImages(List<V1ContainerImage> images);
    public A withImages(V1ContainerImage... images);
    public Boolean hasImages();
    public V1NodeStatusFluent.ImagesNested<A> addNewImage();
    public V1NodeStatusFluent.ImagesNested<A> addNewImageLike(V1ContainerImage item);
    public V1NodeStatusFluent.ImagesNested<A> setNewImageLike(int index,V1ContainerImage item);
    public V1NodeStatusFluent.ImagesNested<A> editImage(int index);
    public V1NodeStatusFluent.ImagesNested<A> editFirstImage();
    public V1NodeStatusFluent.ImagesNested<A> editLastImage();
    public V1NodeStatusFluent.ImagesNested<A> editMatchingImage(io.kubernetes.client.fluent.Predicate<V1ContainerImageBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildNodeInfo instead.
 * @return The buildable object.
 */
@Deprecated public V1NodeSystemInfo getNodeInfo();
    public V1NodeSystemInfo buildNodeInfo();
    public A withNodeInfo(V1NodeSystemInfo nodeInfo);
    public Boolean hasNodeInfo();
    public V1NodeStatusFluent.NodeInfoNested<A> withNewNodeInfo();
    public V1NodeStatusFluent.NodeInfoNested<A> withNewNodeInfoLike(V1NodeSystemInfo item);
    public V1NodeStatusFluent.NodeInfoNested<A> editNodeInfo();
    public V1NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfo();
    public V1NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfoLike(V1NodeSystemInfo item);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(String arg1);
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(StringBuffer arg1);
    public A addToVolumesAttached(int index,V1AttachedVolume item);
    public A setToVolumesAttached(int index,V1AttachedVolume item);
    public A addToVolumesAttached(V1AttachedVolume... items);
    public A addAllToVolumesAttached(Collection<V1AttachedVolume> items);
    public A removeFromVolumesAttached(V1AttachedVolume... items);
    public A removeAllFromVolumesAttached(Collection<V1AttachedVolume> items);
    public A removeMatchingFromVolumesAttached(io.kubernetes.client.fluent.Predicate<V1AttachedVolumeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumesAttached instead.
 * @return The buildable object.
 */
@Deprecated public List<V1AttachedVolume> getVolumesAttached();
    public List<V1AttachedVolume> buildVolumesAttached();
    public V1AttachedVolume buildVolumesAttached(int index);
    public V1AttachedVolume buildFirstVolumesAttached();
    public V1AttachedVolume buildLastVolumesAttached();
    public V1AttachedVolume buildMatchingVolumesAttached(io.kubernetes.client.fluent.Predicate<V1AttachedVolumeBuilder> predicate);
    public Boolean hasMatchingVolumesAttached(io.kubernetes.client.fluent.Predicate<V1AttachedVolumeBuilder> predicate);
    public A withVolumesAttached(List<V1AttachedVolume> volumesAttached);
    public A withVolumesAttached(V1AttachedVolume... volumesAttached);
    public Boolean hasVolumesAttached();
    public V1NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttached();
    public V1NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttachedLike(V1AttachedVolume item);
    public V1NodeStatusFluent.VolumesAttachedNested<A> setNewVolumesAttachedLike(int index,V1AttachedVolume item);
    public V1NodeStatusFluent.VolumesAttachedNested<A> editVolumesAttached(int index);
    public V1NodeStatusFluent.VolumesAttachedNested<A> editFirstVolumesAttached();
    public V1NodeStatusFluent.VolumesAttachedNested<A> editLastVolumesAttached();
    public V1NodeStatusFluent.VolumesAttachedNested<A> editMatchingVolumesAttached(io.kubernetes.client.fluent.Predicate<V1AttachedVolumeBuilder> predicate);
    public A addToVolumesInUse(int index,String item);
    public A setToVolumesInUse(int index,String item);
    public A addToVolumesInUse(String... items);
    public A addAllToVolumesInUse(Collection<String> items);
    public A removeFromVolumesInUse(String... items);
    public A removeAllFromVolumesInUse(Collection<String> items);
    public List<String> getVolumesInUse();
    public String getVolumesInUse(int index);
    public String getFirstVolumesInUse();
    public String getLastVolumesInUse();
    public String getMatchingVolumesInUse(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingVolumesInUse(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withVolumesInUse(List<String> volumesInUse);
    public A withVolumesInUse(String... volumesInUse);
    public Boolean hasVolumesInUse();
    public A addNewVolumesInUse(String arg1);
    public A addNewVolumesInUse(StringBuilder arg1);
    public A addNewVolumesInUse(StringBuffer arg1);
    public interface AddressesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1NodeAddressFluent<V1NodeStatusFluent.AddressesNested<N>> {

        public N and();
        public N endAddress();    }


    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1NodeConditionFluent<V1NodeStatusFluent.ConditionsNested<N>> {

        public N and();
        public N endCondition();    }


    public interface ConfigNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1NodeConfigStatusFluent<V1NodeStatusFluent.ConfigNested<N>> {

        public N and();
        public N endConfig();    }


    public interface DaemonEndpointsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1NodeDaemonEndpointsFluent<V1NodeStatusFluent.DaemonEndpointsNested<N>> {

        public N and();
        public N endDaemonEndpoints();    }


    public interface ImagesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ContainerImageFluent<V1NodeStatusFluent.ImagesNested<N>> {

        public N and();
        public N endImage();    }


    public interface NodeInfoNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1NodeSystemInfoFluent<V1NodeStatusFluent.NodeInfoNested<N>> {

        public N and();
        public N endNodeInfo();    }


    public interface VolumesAttachedNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1AttachedVolumeFluent<V1NodeStatusFluent.VolumesAttachedNested<N>> {

        public N and();
        public N endVolumesAttached();    }


}
