package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NodeConfigSourceBuilder extends V1NodeConfigSourceFluentImpl<V1NodeConfigSourceBuilder> implements VisitableBuilder<V1NodeConfigSource,V1NodeConfigSourceBuilder> {

    V1NodeConfigSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1NodeConfigSourceBuilder() { 
        this(true);
    }


    public V1NodeConfigSourceBuilder(Boolean validationEnabled) { 
        this(new V1NodeConfigSource(), validationEnabled);
    }


    public V1NodeConfigSourceBuilder(V1NodeConfigSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1NodeConfigSourceBuilder(V1NodeConfigSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1NodeConfigSource(), validationEnabled);
    }


    public V1NodeConfigSourceBuilder(V1NodeConfigSourceFluent<?> fluent,V1NodeConfigSource instance) { 
        this(fluent, instance, true);
    }


    public V1NodeConfigSourceBuilder(V1NodeConfigSourceFluent<?> fluent,V1NodeConfigSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withConfigMap(instance.getConfigMap());

        this.validationEnabled = validationEnabled; 
    }


    public V1NodeConfigSourceBuilder(V1NodeConfigSource instance) { 
        this(instance,true);
    }


    public V1NodeConfigSourceBuilder(V1NodeConfigSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withConfigMap(instance.getConfigMap());

        this.validationEnabled = validationEnabled; 
    }


    public V1NodeConfigSource build() {
        V1NodeConfigSource buildable = new V1NodeConfigSource();
        buildable.setConfigMap(fluent.getConfigMap());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1NodeConfigSourceBuilder that = (V1NodeConfigSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
