package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1LifecycleFluentImpl<A extends V1LifecycleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1LifecycleFluent<A> {

    private V1HandlerBuilder postStart;
    private V1HandlerBuilder preStop;

    public V1LifecycleFluentImpl() { 
    }


    public V1LifecycleFluentImpl(V1Lifecycle instance) { 
        this.withPostStart(instance.getPostStart());

        this.withPreStop(instance.getPreStop());

    }


    
/**
 * This method has been deprecated, please use method buildPostStart instead.
 * @return The buildable object.
 */
@Deprecated public V1Handler getPostStart() {
        return this.postStart!=null?this.postStart.build():null;
    }

    public V1Handler buildPostStart() {
        return this.postStart!=null?this.postStart.build():null;
    }

    public A withPostStart(V1Handler postStart) {
        _visitables.get("postStart").remove(this.postStart);
        if (postStart!=null){ this.postStart= new V1HandlerBuilder(postStart); _visitables.get("postStart").add(this.postStart);} return (A) this;
    }

    public Boolean hasPostStart() {
        return this.postStart != null;
    }

    public V1LifecycleFluent.PostStartNested<A> withNewPostStart() {
        return new PostStartNestedImpl();
    }

    public V1LifecycleFluent.PostStartNested<A> withNewPostStartLike(V1Handler item) {
        return new PostStartNestedImpl(item);
    }

    public V1LifecycleFluent.PostStartNested<A> editPostStart() {
        return withNewPostStartLike(getPostStart());
    }

    public V1LifecycleFluent.PostStartNested<A> editOrNewPostStart() {
        return withNewPostStartLike(getPostStart() != null ? getPostStart(): new V1HandlerBuilder().build());
    }

    public V1LifecycleFluent.PostStartNested<A> editOrNewPostStartLike(V1Handler item) {
        return withNewPostStartLike(getPostStart() != null ? getPostStart(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPreStop instead.
 * @return The buildable object.
 */
@Deprecated public V1Handler getPreStop() {
        return this.preStop!=null?this.preStop.build():null;
    }

    public V1Handler buildPreStop() {
        return this.preStop!=null?this.preStop.build():null;
    }

    public A withPreStop(V1Handler preStop) {
        _visitables.get("preStop").remove(this.preStop);
        if (preStop!=null){ this.preStop= new V1HandlerBuilder(preStop); _visitables.get("preStop").add(this.preStop);} return (A) this;
    }

    public Boolean hasPreStop() {
        return this.preStop != null;
    }

    public V1LifecycleFluent.PreStopNested<A> withNewPreStop() {
        return new PreStopNestedImpl();
    }

    public V1LifecycleFluent.PreStopNested<A> withNewPreStopLike(V1Handler item) {
        return new PreStopNestedImpl(item);
    }

    public V1LifecycleFluent.PreStopNested<A> editPreStop() {
        return withNewPreStopLike(getPreStop());
    }

    public V1LifecycleFluent.PreStopNested<A> editOrNewPreStop() {
        return withNewPreStopLike(getPreStop() != null ? getPreStop(): new V1HandlerBuilder().build());
    }

    public V1LifecycleFluent.PreStopNested<A> editOrNewPreStopLike(V1Handler item) {
        return withNewPreStopLike(getPreStop() != null ? getPreStop(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1LifecycleFluentImpl that = (V1LifecycleFluentImpl) o;
        if (postStart != null ? !postStart.equals(that.postStart) :that.postStart != null) return false;
        if (preStop != null ? !preStop.equals(that.preStop) :that.preStop != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(postStart,  preStop,  super.hashCode());
    }

    public class PostStartNestedImpl<N> extends V1HandlerFluentImpl<V1LifecycleFluent.PostStartNested<N>> implements V1LifecycleFluent.PostStartNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1HandlerBuilder builder;

        PostStartNestedImpl(V1Handler item) {
            this.builder = new V1HandlerBuilder(this, item);
        }

        PostStartNestedImpl() {
            this.builder = new V1HandlerBuilder(this);
        }

        public N and() {
             return (N) V1LifecycleFluentImpl.this.withPostStart(builder.build());
        }

        public N endPostStart() {
             return and();
        }
    }


    public class PreStopNestedImpl<N> extends V1HandlerFluentImpl<V1LifecycleFluent.PreStopNested<N>> implements V1LifecycleFluent.PreStopNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1HandlerBuilder builder;

        PreStopNestedImpl(V1Handler item) {
            this.builder = new V1HandlerBuilder(this, item);
        }

        PreStopNestedImpl() {
            this.builder = new V1HandlerBuilder(this);
        }

        public N and() {
             return (N) V1LifecycleFluentImpl.this.withPreStop(builder.build());
        }

        public N endPreStop() {
             return and();
        }
    }


}
