package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1LeaseListBuilder extends V1LeaseListFluentImpl<V1LeaseListBuilder> implements VisitableBuilder<V1LeaseList,V1LeaseListBuilder> {

    V1LeaseListFluent<?> fluent;
    Boolean validationEnabled;

    public V1LeaseListBuilder() { 
        this(true);
    }


    public V1LeaseListBuilder(Boolean validationEnabled) { 
        this(new V1LeaseList(), validationEnabled);
    }


    public V1LeaseListBuilder(V1LeaseListFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1LeaseListBuilder(V1LeaseListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1LeaseList(), validationEnabled);
    }


    public V1LeaseListBuilder(V1LeaseListFluent<?> fluent,V1LeaseList instance) { 
        this(fluent, instance, true);
    }


    public V1LeaseListBuilder(V1LeaseListFluent<?> fluent,V1LeaseList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withItems(instance.getItems());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public V1LeaseListBuilder(V1LeaseList instance) { 
        this(instance,true);
    }


    public V1LeaseListBuilder(V1LeaseList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withItems(instance.getItems());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public V1LeaseList build() {
        V1LeaseList buildable = new V1LeaseList();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setItems(fluent.getItems());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1LeaseListBuilder that = (V1LeaseListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
