package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1IngressSpecBuilder extends V1IngressSpecFluentImpl<V1IngressSpecBuilder> implements VisitableBuilder<V1IngressSpec,V1IngressSpecBuilder> {

    V1IngressSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1IngressSpecBuilder() { 
        this(true);
    }


    public V1IngressSpecBuilder(Boolean validationEnabled) { 
        this(new V1IngressSpec(), validationEnabled);
    }


    public V1IngressSpecBuilder(V1IngressSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1IngressSpecBuilder(V1IngressSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1IngressSpec(), validationEnabled);
    }


    public V1IngressSpecBuilder(V1IngressSpecFluent<?> fluent,V1IngressSpec instance) { 
        this(fluent, instance, true);
    }


    public V1IngressSpecBuilder(V1IngressSpecFluent<?> fluent,V1IngressSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDefaultBackend(instance.getDefaultBackend());

        fluent.withIngressClassName(instance.getIngressClassName());

        fluent.withRules(instance.getRules());

        fluent.withTls(instance.getTls());

        this.validationEnabled = validationEnabled; 
    }


    public V1IngressSpecBuilder(V1IngressSpec instance) { 
        this(instance,true);
    }


    public V1IngressSpecBuilder(V1IngressSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDefaultBackend(instance.getDefaultBackend());

        this.withIngressClassName(instance.getIngressClassName());

        this.withRules(instance.getRules());

        this.withTls(instance.getTls());

        this.validationEnabled = validationEnabled; 
    }


    public V1IngressSpec build() {
        V1IngressSpec buildable = new V1IngressSpec();
        buildable.setDefaultBackend(fluent.getDefaultBackend());
        buildable.setIngressClassName(fluent.getIngressClassName());
        buildable.setRules(fluent.getRules());
        buildable.setTls(fluent.getTls());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1IngressSpecBuilder that = (V1IngressSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
