package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1IngressServiceBackendBuilder extends V1IngressServiceBackendFluentImpl<V1IngressServiceBackendBuilder> implements VisitableBuilder<V1IngressServiceBackend,V1IngressServiceBackendBuilder> {

    V1IngressServiceBackendFluent<?> fluent;
    Boolean validationEnabled;

    public V1IngressServiceBackendBuilder() { 
        this(true);
    }


    public V1IngressServiceBackendBuilder(Boolean validationEnabled) { 
        this(new V1IngressServiceBackend(), validationEnabled);
    }


    public V1IngressServiceBackendBuilder(V1IngressServiceBackendFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1IngressServiceBackendBuilder(V1IngressServiceBackendFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1IngressServiceBackend(), validationEnabled);
    }


    public V1IngressServiceBackendBuilder(V1IngressServiceBackendFluent<?> fluent,V1IngressServiceBackend instance) { 
        this(fluent, instance, true);
    }


    public V1IngressServiceBackendBuilder(V1IngressServiceBackendFluent<?> fluent,V1IngressServiceBackend instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName());

        fluent.withPort(instance.getPort());

        this.validationEnabled = validationEnabled; 
    }


    public V1IngressServiceBackendBuilder(V1IngressServiceBackend instance) { 
        this(instance,true);
    }


    public V1IngressServiceBackendBuilder(V1IngressServiceBackend instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName());

        this.withPort(instance.getPort());

        this.validationEnabled = validationEnabled; 
    }


    public V1IngressServiceBackend build() {
        V1IngressServiceBackend buildable = new V1IngressServiceBackend();
        buildable.setName(fluent.getName());
        buildable.setPort(fluent.getPort());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1IngressServiceBackendBuilder that = (V1IngressServiceBackendBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
