package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1IngressClassSpecBuilder extends V1IngressClassSpecFluentImpl<V1IngressClassSpecBuilder> implements VisitableBuilder<V1IngressClassSpec,V1IngressClassSpecBuilder> {

    V1IngressClassSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1IngressClassSpecBuilder() { 
        this(true);
    }


    public V1IngressClassSpecBuilder(Boolean validationEnabled) { 
        this(new V1IngressClassSpec(), validationEnabled);
    }


    public V1IngressClassSpecBuilder(V1IngressClassSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1IngressClassSpecBuilder(V1IngressClassSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1IngressClassSpec(), validationEnabled);
    }


    public V1IngressClassSpecBuilder(V1IngressClassSpecFluent<?> fluent,V1IngressClassSpec instance) { 
        this(fluent, instance, true);
    }


    public V1IngressClassSpecBuilder(V1IngressClassSpecFluent<?> fluent,V1IngressClassSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withController(instance.getController());

        fluent.withParameters(instance.getParameters());

        this.validationEnabled = validationEnabled; 
    }


    public V1IngressClassSpecBuilder(V1IngressClassSpec instance) { 
        this(instance,true);
    }


    public V1IngressClassSpecBuilder(V1IngressClassSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withController(instance.getController());

        this.withParameters(instance.getParameters());

        this.validationEnabled = validationEnabled; 
    }


    public V1IngressClassSpec build() {
        V1IngressClassSpec buildable = new V1IngressClassSpec();
        buildable.setController(fluent.getController());
        buildable.setParameters(fluent.getParameters());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1IngressClassSpecBuilder that = (V1IngressClassSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
