package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1EphemeralVolumeSourceFluentImpl<A extends V1EphemeralVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1EphemeralVolumeSourceFluent<A> {

    private Boolean readOnly;
    private V1PersistentVolumeClaimTemplateBuilder volumeClaimTemplate;

    public V1EphemeralVolumeSourceFluentImpl() { 
    }


    public V1EphemeralVolumeSourceFluentImpl(V1EphemeralVolumeSource instance) { 
        this.withReadOnly(instance.getReadOnly());

        this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());

    }


    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildVolumeClaimTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PersistentVolumeClaimTemplate getVolumeClaimTemplate() {
        return this.volumeClaimTemplate!=null?this.volumeClaimTemplate.build():null;
    }

    public V1PersistentVolumeClaimTemplate buildVolumeClaimTemplate() {
        return this.volumeClaimTemplate!=null?this.volumeClaimTemplate.build():null;
    }

    public A withVolumeClaimTemplate(V1PersistentVolumeClaimTemplate volumeClaimTemplate) {
        _visitables.get("volumeClaimTemplate").remove(this.volumeClaimTemplate);
        if (volumeClaimTemplate!=null){ this.volumeClaimTemplate= new V1PersistentVolumeClaimTemplateBuilder(volumeClaimTemplate); _visitables.get("volumeClaimTemplate").add(this.volumeClaimTemplate);} return (A) this;
    }

    public Boolean hasVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null;
    }

    public V1EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate() {
        return new VolumeClaimTemplateNestedImpl();
    }

    public V1EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(V1PersistentVolumeClaimTemplate item) {
        return new VolumeClaimTemplateNestedImpl(item);
    }

    public V1EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> editVolumeClaimTemplate() {
        return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate());
    }

    public V1EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate() {
        return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate() != null ? getVolumeClaimTemplate(): new V1PersistentVolumeClaimTemplateBuilder().build());
    }

    public V1EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(V1PersistentVolumeClaimTemplate item) {
        return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate() != null ? getVolumeClaimTemplate(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1EphemeralVolumeSourceFluentImpl that = (V1EphemeralVolumeSourceFluentImpl) o;
        if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
        if (volumeClaimTemplate != null ? !volumeClaimTemplate.equals(that.volumeClaimTemplate) :that.volumeClaimTemplate != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(readOnly,  volumeClaimTemplate,  super.hashCode());
    }

    public class VolumeClaimTemplateNestedImpl<N> extends V1PersistentVolumeClaimTemplateFluentImpl<V1EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<N>> implements V1EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1PersistentVolumeClaimTemplateBuilder builder;

        VolumeClaimTemplateNestedImpl(V1PersistentVolumeClaimTemplate item) {
            this.builder = new V1PersistentVolumeClaimTemplateBuilder(this, item);
        }

        VolumeClaimTemplateNestedImpl() {
            this.builder = new V1PersistentVolumeClaimTemplateBuilder(this);
        }

        public N and() {
             return (N) V1EphemeralVolumeSourceFluentImpl.this.withVolumeClaimTemplate(builder.build());
        }

        public N endVolumeClaimTemplate() {
             return and();
        }
    }


}
