package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1DaemonSetListBuilder extends V1DaemonSetListFluentImpl<V1DaemonSetListBuilder> implements VisitableBuilder<V1DaemonSetList,V1DaemonSetListBuilder> {

    V1DaemonSetListFluent<?> fluent;
    Boolean validationEnabled;

    public V1DaemonSetListBuilder() { 
        this(true);
    }


    public V1DaemonSetListBuilder(Boolean validationEnabled) { 
        this(new V1DaemonSetList(), validationEnabled);
    }


    public V1DaemonSetListBuilder(V1DaemonSetListFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1DaemonSetListBuilder(V1DaemonSetListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1DaemonSetList(), validationEnabled);
    }


    public V1DaemonSetListBuilder(V1DaemonSetListFluent<?> fluent,V1DaemonSetList instance) { 
        this(fluent, instance, true);
    }


    public V1DaemonSetListBuilder(V1DaemonSetListFluent<?> fluent,V1DaemonSetList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withItems(instance.getItems());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public V1DaemonSetListBuilder(V1DaemonSetList instance) { 
        this(instance,true);
    }


    public V1DaemonSetListBuilder(V1DaemonSetList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withItems(instance.getItems());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public V1DaemonSetList build() {
        V1DaemonSetList buildable = new V1DaemonSetList();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setItems(fluent.getItems());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1DaemonSetListBuilder that = (V1DaemonSetListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
