package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ConfigMapListBuilder extends V1ConfigMapListFluentImpl<V1ConfigMapListBuilder> implements VisitableBuilder<V1ConfigMapList,V1ConfigMapListBuilder> {

    V1ConfigMapListFluent<?> fluent;
    Boolean validationEnabled;

    public V1ConfigMapListBuilder() { 
        this(true);
    }


    public V1ConfigMapListBuilder(Boolean validationEnabled) { 
        this(new V1ConfigMapList(), validationEnabled);
    }


    public V1ConfigMapListBuilder(V1ConfigMapListFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1ConfigMapListBuilder(V1ConfigMapListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1ConfigMapList(), validationEnabled);
    }


    public V1ConfigMapListBuilder(V1ConfigMapListFluent<?> fluent,V1ConfigMapList instance) { 
        this(fluent, instance, true);
    }


    public V1ConfigMapListBuilder(V1ConfigMapListFluent<?> fluent,V1ConfigMapList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withItems(instance.getItems());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public V1ConfigMapListBuilder(V1ConfigMapList instance) { 
        this(instance,true);
    }


    public V1ConfigMapListBuilder(V1ConfigMapList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withItems(instance.getItems());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public V1ConfigMapList build() {
        V1ConfigMapList buildable = new V1ConfigMapList();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setItems(fluent.getItems());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1ConfigMapListBuilder that = (V1ConfigMapListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
