package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1CapabilitiesBuilder extends V1CapabilitiesFluentImpl<V1CapabilitiesBuilder> implements VisitableBuilder<V1Capabilities,V1CapabilitiesBuilder> {

    V1CapabilitiesFluent<?> fluent;
    Boolean validationEnabled;

    public V1CapabilitiesBuilder() { 
        this(true);
    }


    public V1CapabilitiesBuilder(Boolean validationEnabled) { 
        this(new V1Capabilities(), validationEnabled);
    }


    public V1CapabilitiesBuilder(V1CapabilitiesFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1CapabilitiesBuilder(V1CapabilitiesFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1Capabilities(), validationEnabled);
    }


    public V1CapabilitiesBuilder(V1CapabilitiesFluent<?> fluent,V1Capabilities instance) { 
        this(fluent, instance, true);
    }


    public V1CapabilitiesBuilder(V1CapabilitiesFluent<?> fluent,V1Capabilities instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAdd(instance.getAdd());

        fluent.withDrop(instance.getDrop());

        this.validationEnabled = validationEnabled; 
    }


    public V1CapabilitiesBuilder(V1Capabilities instance) { 
        this(instance,true);
    }


    public V1CapabilitiesBuilder(V1Capabilities instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAdd(instance.getAdd());

        this.withDrop(instance.getDrop());

        this.validationEnabled = validationEnabled; 
    }


    public V1Capabilities build() {
        V1Capabilities buildable = new V1Capabilities();
        buildable.setAdd(fluent.getAdd());
        buildable.setDrop(fluent.getDrop());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1CapabilitiesBuilder that = (V1CapabilitiesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
