package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1CSINodeSpecBuilder extends V1CSINodeSpecFluentImpl<V1CSINodeSpecBuilder> implements VisitableBuilder<V1CSINodeSpec,V1CSINodeSpecBuilder> {

    V1CSINodeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1CSINodeSpecBuilder() { 
        this(true);
    }


    public V1CSINodeSpecBuilder(Boolean validationEnabled) { 
        this(new V1CSINodeSpec(), validationEnabled);
    }


    public V1CSINodeSpecBuilder(V1CSINodeSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1CSINodeSpecBuilder(V1CSINodeSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1CSINodeSpec(), validationEnabled);
    }


    public V1CSINodeSpecBuilder(V1CSINodeSpecFluent<?> fluent,V1CSINodeSpec instance) { 
        this(fluent, instance, true);
    }


    public V1CSINodeSpecBuilder(V1CSINodeSpecFluent<?> fluent,V1CSINodeSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDrivers(instance.getDrivers());

        this.validationEnabled = validationEnabled; 
    }


    public V1CSINodeSpecBuilder(V1CSINodeSpec instance) { 
        this(instance,true);
    }


    public V1CSINodeSpecBuilder(V1CSINodeSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDrivers(instance.getDrivers());

        this.validationEnabled = validationEnabled; 
    }


    public V1CSINodeSpec build() {
        V1CSINodeSpec buildable = new V1CSINodeSpec();
        buildable.setDrivers(fluent.getDrivers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1CSINodeSpecBuilder that = (V1CSINodeSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
