package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1APIServiceBuilder extends V1APIServiceFluentImpl<V1APIServiceBuilder> implements VisitableBuilder<V1APIService,V1APIServiceBuilder> {

    V1APIServiceFluent<?> fluent;
    Boolean validationEnabled;

    public V1APIServiceBuilder() { 
        this(true);
    }


    public V1APIServiceBuilder(Boolean validationEnabled) { 
        this(new V1APIService(), validationEnabled);
    }


    public V1APIServiceBuilder(V1APIServiceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1APIServiceBuilder(V1APIServiceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1APIService(), validationEnabled);
    }


    public V1APIServiceBuilder(V1APIServiceFluent<?> fluent,V1APIService instance) { 
        this(fluent, instance, true);
    }


    public V1APIServiceBuilder(V1APIServiceFluent<?> fluent,V1APIService instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        fluent.withSpec(instance.getSpec());

        fluent.withStatus(instance.getStatus());

        this.validationEnabled = validationEnabled; 
    }


    public V1APIServiceBuilder(V1APIService instance) { 
        this(instance,true);
    }


    public V1APIServiceBuilder(V1APIService instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withSpec(instance.getSpec());

        this.withStatus(instance.getStatus());

        this.validationEnabled = validationEnabled; 
    }


    public V1APIService build() {
        V1APIService buildable = new V1APIService();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1APIServiceBuilder that = (V1APIServiceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
