package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1APIGroupFluent<A extends V1APIGroupFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildPreferredVersion instead.
 * @return The buildable object.
 */
@Deprecated public V1GroupVersionForDiscovery getPreferredVersion();
    public V1GroupVersionForDiscovery buildPreferredVersion();
    public A withPreferredVersion(V1GroupVersionForDiscovery preferredVersion);
    public Boolean hasPreferredVersion();
    public V1APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersion();
    public V1APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersionLike(V1GroupVersionForDiscovery item);
    public V1APIGroupFluent.PreferredVersionNested<A> editPreferredVersion();
    public V1APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersion();
    public V1APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersionLike(V1GroupVersionForDiscovery item);
    public A addToServerAddressByClientCIDRs(int index,V1ServerAddressByClientCIDR item);
    public A setToServerAddressByClientCIDRs(int index,V1ServerAddressByClientCIDR item);
    public A addToServerAddressByClientCIDRs(V1ServerAddressByClientCIDR... items);
    public A addAllToServerAddressByClientCIDRs(Collection<V1ServerAddressByClientCIDR> items);
    public A removeFromServerAddressByClientCIDRs(V1ServerAddressByClientCIDR... items);
    public A removeAllFromServerAddressByClientCIDRs(Collection<V1ServerAddressByClientCIDR> items);
    public A removeMatchingFromServerAddressByClientCIDRs(io.kubernetes.client.fluent.Predicate<V1ServerAddressByClientCIDRBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildServerAddressByClientCIDRs instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ServerAddressByClientCIDR> getServerAddressByClientCIDRs();
    public List<V1ServerAddressByClientCIDR> buildServerAddressByClientCIDRs();
    public V1ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index);
    public V1ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR();
    public V1ServerAddressByClientCIDR buildLastServerAddressByClientCIDR();
    public V1ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(io.kubernetes.client.fluent.Predicate<V1ServerAddressByClientCIDRBuilder> predicate);
    public Boolean hasMatchingServerAddressByClientCIDR(io.kubernetes.client.fluent.Predicate<V1ServerAddressByClientCIDRBuilder> predicate);
    public A withServerAddressByClientCIDRs(List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs);
    public A withServerAddressByClientCIDRs(V1ServerAddressByClientCIDR... serverAddressByClientCIDRs);
    public Boolean hasServerAddressByClientCIDRs();
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR();
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(V1ServerAddressByClientCIDR item);
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index,V1ServerAddressByClientCIDR item);
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index);
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR();
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR();
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(io.kubernetes.client.fluent.Predicate<V1ServerAddressByClientCIDRBuilder> predicate);
    public A addToVersions(int index,V1GroupVersionForDiscovery item);
    public A setToVersions(int index,V1GroupVersionForDiscovery item);
    public A addToVersions(V1GroupVersionForDiscovery... items);
    public A addAllToVersions(Collection<V1GroupVersionForDiscovery> items);
    public A removeFromVersions(V1GroupVersionForDiscovery... items);
    public A removeAllFromVersions(Collection<V1GroupVersionForDiscovery> items);
    public A removeMatchingFromVersions(io.kubernetes.client.fluent.Predicate<V1GroupVersionForDiscoveryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVersions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1GroupVersionForDiscovery> getVersions();
    public List<V1GroupVersionForDiscovery> buildVersions();
    public V1GroupVersionForDiscovery buildVersion(int index);
    public V1GroupVersionForDiscovery buildFirstVersion();
    public V1GroupVersionForDiscovery buildLastVersion();
    public V1GroupVersionForDiscovery buildMatchingVersion(io.kubernetes.client.fluent.Predicate<V1GroupVersionForDiscoveryBuilder> predicate);
    public Boolean hasMatchingVersion(io.kubernetes.client.fluent.Predicate<V1GroupVersionForDiscoveryBuilder> predicate);
    public A withVersions(List<V1GroupVersionForDiscovery> versions);
    public A withVersions(V1GroupVersionForDiscovery... versions);
    public Boolean hasVersions();
    public V1APIGroupFluent.VersionsNested<A> addNewVersion();
    public V1APIGroupFluent.VersionsNested<A> addNewVersionLike(V1GroupVersionForDiscovery item);
    public V1APIGroupFluent.VersionsNested<A> setNewVersionLike(int index,V1GroupVersionForDiscovery item);
    public V1APIGroupFluent.VersionsNested<A> editVersion(int index);
    public V1APIGroupFluent.VersionsNested<A> editFirstVersion();
    public V1APIGroupFluent.VersionsNested<A> editLastVersion();
    public V1APIGroupFluent.VersionsNested<A> editMatchingVersion(io.kubernetes.client.fluent.Predicate<V1GroupVersionForDiscoveryBuilder> predicate);
    public interface PreferredVersionNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1GroupVersionForDiscoveryFluent<V1APIGroupFluent.PreferredVersionNested<N>> {

        public N and();
        public N endPreferredVersion();    }


    public interface ServerAddressByClientCIDRsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ServerAddressByClientCIDRFluent<V1APIGroupFluent.ServerAddressByClientCIDRsNested<N>> {

        public N and();
        public N endServerAddressByClientCIDR();    }


    public interface VersionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1GroupVersionForDiscoveryFluent<V1APIGroupFluent.VersionsNested<N>> {

        public N and();
        public N endVersion();    }


}
