package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import org.joda.time.DateTime;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;

public class EventsV1EventFluentImpl<A extends EventsV1EventFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements EventsV1EventFluent<A> {

    private String action;
    private String apiVersion;
    private Integer deprecatedCount;
    private DateTime deprecatedFirstTimestamp;
    private DateTime deprecatedLastTimestamp;
    private V1EventSourceBuilder deprecatedSource;
    private DateTime eventTime;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private String note;
    private String reason;
    private V1ObjectReferenceBuilder regarding;
    private V1ObjectReferenceBuilder related;
    private String reportingController;
    private String reportingInstance;
    private EventsV1EventSeriesBuilder series;
    private String type;

    public EventsV1EventFluentImpl() { 
    }


    public EventsV1EventFluentImpl(EventsV1Event instance) { 
        this.withAction(instance.getAction());

        this.withApiVersion(instance.getApiVersion());

        this.withDeprecatedCount(instance.getDeprecatedCount());

        this.withDeprecatedFirstTimestamp(instance.getDeprecatedFirstTimestamp());

        this.withDeprecatedLastTimestamp(instance.getDeprecatedLastTimestamp());

        this.withDeprecatedSource(instance.getDeprecatedSource());

        this.withEventTime(instance.getEventTime());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withNote(instance.getNote());

        this.withReason(instance.getReason());

        this.withRegarding(instance.getRegarding());

        this.withRelated(instance.getRelated());

        this.withReportingController(instance.getReportingController());

        this.withReportingInstance(instance.getReportingInstance());

        this.withSeries(instance.getSeries());

        this.withType(instance.getType());

    }


    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action=action; return (A) this;
    }

    public Boolean hasAction() {
        return this.action != null;
    }

    public A withNewAction(String arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuilder arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuffer arg1) {
        return (A)withAction(new String(arg1));
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public Integer getDeprecatedCount() {
        return this.deprecatedCount;
    }

    public A withDeprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount=deprecatedCount; return (A) this;
    }

    public Boolean hasDeprecatedCount() {
        return this.deprecatedCount != null;
    }

    public DateTime getDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp;
    }

    public A withDeprecatedFirstTimestamp(DateTime deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp=deprecatedFirstTimestamp; return (A) this;
    }

    public Boolean hasDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp != null;
    }

    public A withNewDeprecatedFirstTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4) {
        return (A)withDeprecatedFirstTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewDeprecatedFirstTimestamp(Object arg0) {
        return (A)withDeprecatedFirstTimestamp(new DateTime(arg0));
    }

    public A withNewDeprecatedFirstTimestamp(long arg0) {
        return (A)withDeprecatedFirstTimestamp(new DateTime(arg0));
    }

    public DateTime getDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp;
    }

    public A withDeprecatedLastTimestamp(DateTime deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp=deprecatedLastTimestamp; return (A) this;
    }

    public Boolean hasDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp != null;
    }

    public A withNewDeprecatedLastTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4) {
        return (A)withDeprecatedLastTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewDeprecatedLastTimestamp(Object arg0) {
        return (A)withDeprecatedLastTimestamp(new DateTime(arg0));
    }

    public A withNewDeprecatedLastTimestamp(long arg0) {
        return (A)withDeprecatedLastTimestamp(new DateTime(arg0));
    }

    
/**
 * This method has been deprecated, please use method buildDeprecatedSource instead.
 * @return The buildable object.
 */
@Deprecated public V1EventSource getDeprecatedSource() {
        return this.deprecatedSource!=null?this.deprecatedSource.build():null;
    }

    public V1EventSource buildDeprecatedSource() {
        return this.deprecatedSource!=null?this.deprecatedSource.build():null;
    }

    public A withDeprecatedSource(V1EventSource deprecatedSource) {
        _visitables.get("deprecatedSource").remove(this.deprecatedSource);
        if (deprecatedSource!=null){ this.deprecatedSource= new V1EventSourceBuilder(deprecatedSource); _visitables.get("deprecatedSource").add(this.deprecatedSource);} return (A) this;
    }

    public Boolean hasDeprecatedSource() {
        return this.deprecatedSource != null;
    }

    public EventsV1EventFluent.DeprecatedSourceNested<A> withNewDeprecatedSource() {
        return new DeprecatedSourceNestedImpl();
    }

    public EventsV1EventFluent.DeprecatedSourceNested<A> withNewDeprecatedSourceLike(V1EventSource item) {
        return new DeprecatedSourceNestedImpl(item);
    }

    public EventsV1EventFluent.DeprecatedSourceNested<A> editDeprecatedSource() {
        return withNewDeprecatedSourceLike(getDeprecatedSource());
    }

    public EventsV1EventFluent.DeprecatedSourceNested<A> editOrNewDeprecatedSource() {
        return withNewDeprecatedSourceLike(getDeprecatedSource() != null ? getDeprecatedSource(): new V1EventSourceBuilder().build());
    }

    public EventsV1EventFluent.DeprecatedSourceNested<A> editOrNewDeprecatedSourceLike(V1EventSource item) {
        return withNewDeprecatedSourceLike(getDeprecatedSource() != null ? getDeprecatedSource(): item);
    }

    public DateTime getEventTime() {
        return this.eventTime;
    }

    public A withEventTime(DateTime eventTime) {
        this.eventTime=eventTime; return (A) this;
    }

    public Boolean hasEventTime() {
        return this.eventTime != null;
    }

    public A withNewEventTime(int arg0,int arg1,int arg2,int arg3,int arg4) {
        return (A)withEventTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewEventTime(Object arg0) {
        return (A)withEventTime(new DateTime(arg0));
    }

    public A withNewEventTime(long arg0) {
        return (A)withEventTime(new DateTime(arg0));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public EventsV1EventFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public EventsV1EventFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public EventsV1EventFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public EventsV1EventFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public EventsV1EventFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public String getNote() {
        return this.note;
    }

    public A withNote(String note) {
        this.note=note; return (A) this;
    }

    public Boolean hasNote() {
        return this.note != null;
    }

    public A withNewNote(String arg1) {
        return (A)withNote(new String(arg1));
    }

    public A withNewNote(StringBuilder arg1) {
        return (A)withNote(new String(arg1));
    }

    public A withNewNote(StringBuffer arg1) {
        return (A)withNote(new String(arg1));
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason=reason; return (A) this;
    }

    public Boolean hasReason() {
        return this.reason != null;
    }

    public A withNewReason(String arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuilder arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1) {
        return (A)withReason(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRegarding instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getRegarding() {
        return this.regarding!=null?this.regarding.build():null;
    }

    public V1ObjectReference buildRegarding() {
        return this.regarding!=null?this.regarding.build():null;
    }

    public A withRegarding(V1ObjectReference regarding) {
        _visitables.get("regarding").remove(this.regarding);
        if (regarding!=null){ this.regarding= new V1ObjectReferenceBuilder(regarding); _visitables.get("regarding").add(this.regarding);} return (A) this;
    }

    public Boolean hasRegarding() {
        return this.regarding != null;
    }

    public EventsV1EventFluent.RegardingNested<A> withNewRegarding() {
        return new RegardingNestedImpl();
    }

    public EventsV1EventFluent.RegardingNested<A> withNewRegardingLike(V1ObjectReference item) {
        return new RegardingNestedImpl(item);
    }

    public EventsV1EventFluent.RegardingNested<A> editRegarding() {
        return withNewRegardingLike(getRegarding());
    }

    public EventsV1EventFluent.RegardingNested<A> editOrNewRegarding() {
        return withNewRegardingLike(getRegarding() != null ? getRegarding(): new V1ObjectReferenceBuilder().build());
    }

    public EventsV1EventFluent.RegardingNested<A> editOrNewRegardingLike(V1ObjectReference item) {
        return withNewRegardingLike(getRegarding() != null ? getRegarding(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRelated instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getRelated() {
        return this.related!=null?this.related.build():null;
    }

    public V1ObjectReference buildRelated() {
        return this.related!=null?this.related.build():null;
    }

    public A withRelated(V1ObjectReference related) {
        _visitables.get("related").remove(this.related);
        if (related!=null){ this.related= new V1ObjectReferenceBuilder(related); _visitables.get("related").add(this.related);} return (A) this;
    }

    public Boolean hasRelated() {
        return this.related != null;
    }

    public EventsV1EventFluent.RelatedNested<A> withNewRelated() {
        return new RelatedNestedImpl();
    }

    public EventsV1EventFluent.RelatedNested<A> withNewRelatedLike(V1ObjectReference item) {
        return new RelatedNestedImpl(item);
    }

    public EventsV1EventFluent.RelatedNested<A> editRelated() {
        return withNewRelatedLike(getRelated());
    }

    public EventsV1EventFluent.RelatedNested<A> editOrNewRelated() {
        return withNewRelatedLike(getRelated() != null ? getRelated(): new V1ObjectReferenceBuilder().build());
    }

    public EventsV1EventFluent.RelatedNested<A> editOrNewRelatedLike(V1ObjectReference item) {
        return withNewRelatedLike(getRelated() != null ? getRelated(): item);
    }

    public String getReportingController() {
        return this.reportingController;
    }

    public A withReportingController(String reportingController) {
        this.reportingController=reportingController; return (A) this;
    }

    public Boolean hasReportingController() {
        return this.reportingController != null;
    }

    public A withNewReportingController(String arg1) {
        return (A)withReportingController(new String(arg1));
    }

    public A withNewReportingController(StringBuilder arg1) {
        return (A)withReportingController(new String(arg1));
    }

    public A withNewReportingController(StringBuffer arg1) {
        return (A)withReportingController(new String(arg1));
    }

    public String getReportingInstance() {
        return this.reportingInstance;
    }

    public A withReportingInstance(String reportingInstance) {
        this.reportingInstance=reportingInstance; return (A) this;
    }

    public Boolean hasReportingInstance() {
        return this.reportingInstance != null;
    }

    public A withNewReportingInstance(String arg1) {
        return (A)withReportingInstance(new String(arg1));
    }

    public A withNewReportingInstance(StringBuilder arg1) {
        return (A)withReportingInstance(new String(arg1));
    }

    public A withNewReportingInstance(StringBuffer arg1) {
        return (A)withReportingInstance(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSeries instead.
 * @return The buildable object.
 */
@Deprecated public EventsV1EventSeries getSeries() {
        return this.series!=null?this.series.build():null;
    }

    public EventsV1EventSeries buildSeries() {
        return this.series!=null?this.series.build():null;
    }

    public A withSeries(EventsV1EventSeries series) {
        _visitables.get("series").remove(this.series);
        if (series!=null){ this.series= new EventsV1EventSeriesBuilder(series); _visitables.get("series").add(this.series);} return (A) this;
    }

    public Boolean hasSeries() {
        return this.series != null;
    }

    public EventsV1EventFluent.SeriesNested<A> withNewSeries() {
        return new SeriesNestedImpl();
    }

    public EventsV1EventFluent.SeriesNested<A> withNewSeriesLike(EventsV1EventSeries item) {
        return new SeriesNestedImpl(item);
    }

    public EventsV1EventFluent.SeriesNested<A> editSeries() {
        return withNewSeriesLike(getSeries());
    }

    public EventsV1EventFluent.SeriesNested<A> editOrNewSeries() {
        return withNewSeriesLike(getSeries() != null ? getSeries(): new EventsV1EventSeriesBuilder().build());
    }

    public EventsV1EventFluent.SeriesNested<A> editOrNewSeriesLike(EventsV1EventSeries item) {
        return withNewSeriesLike(getSeries() != null ? getSeries(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EventsV1EventFluentImpl that = (EventsV1EventFluentImpl) o;
        if (action != null ? !action.equals(that.action) :that.action != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (deprecatedCount != null ? !deprecatedCount.equals(that.deprecatedCount) :that.deprecatedCount != null) return false;
        if (deprecatedFirstTimestamp != null ? !deprecatedFirstTimestamp.equals(that.deprecatedFirstTimestamp) :that.deprecatedFirstTimestamp != null) return false;
        if (deprecatedLastTimestamp != null ? !deprecatedLastTimestamp.equals(that.deprecatedLastTimestamp) :that.deprecatedLastTimestamp != null) return false;
        if (deprecatedSource != null ? !deprecatedSource.equals(that.deprecatedSource) :that.deprecatedSource != null) return false;
        if (eventTime != null ? !eventTime.equals(that.eventTime) :that.eventTime != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (note != null ? !note.equals(that.note) :that.note != null) return false;
        if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
        if (regarding != null ? !regarding.equals(that.regarding) :that.regarding != null) return false;
        if (related != null ? !related.equals(that.related) :that.related != null) return false;
        if (reportingController != null ? !reportingController.equals(that.reportingController) :that.reportingController != null) return false;
        if (reportingInstance != null ? !reportingInstance.equals(that.reportingInstance) :that.reportingInstance != null) return false;
        if (series != null ? !series.equals(that.series) :that.series != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(action,  apiVersion,  deprecatedCount,  deprecatedFirstTimestamp,  deprecatedLastTimestamp,  deprecatedSource,  eventTime,  kind,  metadata,  note,  reason,  regarding,  related,  reportingController,  reportingInstance,  series,  type,  super.hashCode());
    }

    public class DeprecatedSourceNestedImpl<N> extends V1EventSourceFluentImpl<EventsV1EventFluent.DeprecatedSourceNested<N>> implements EventsV1EventFluent.DeprecatedSourceNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1EventSourceBuilder builder;

        DeprecatedSourceNestedImpl(V1EventSource item) {
            this.builder = new V1EventSourceBuilder(this, item);
        }

        DeprecatedSourceNestedImpl() {
            this.builder = new V1EventSourceBuilder(this);
        }

        public N and() {
             return (N) EventsV1EventFluentImpl.this.withDeprecatedSource(builder.build());
        }

        public N endDeprecatedSource() {
             return and();
        }
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<EventsV1EventFluent.MetadataNested<N>> implements EventsV1EventFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) EventsV1EventFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


    public class RegardingNestedImpl<N> extends V1ObjectReferenceFluentImpl<EventsV1EventFluent.RegardingNested<N>> implements EventsV1EventFluent.RegardingNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ObjectReferenceBuilder builder;

        RegardingNestedImpl(V1ObjectReference item) {
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        RegardingNestedImpl() {
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) EventsV1EventFluentImpl.this.withRegarding(builder.build());
        }

        public N endRegarding() {
             return and();
        }
    }


    public class RelatedNestedImpl<N> extends V1ObjectReferenceFluentImpl<EventsV1EventFluent.RelatedNested<N>> implements EventsV1EventFluent.RelatedNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ObjectReferenceBuilder builder;

        RelatedNestedImpl(V1ObjectReference item) {
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        RelatedNestedImpl() {
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) EventsV1EventFluentImpl.this.withRelated(builder.build());
        }

        public N endRelated() {
             return and();
        }
    }


    public class SeriesNestedImpl<N> extends EventsV1EventSeriesFluentImpl<EventsV1EventFluent.SeriesNested<N>> implements EventsV1EventFluent.SeriesNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final EventsV1EventSeriesBuilder builder;

        SeriesNestedImpl(EventsV1EventSeries item) {
            this.builder = new EventsV1EventSeriesBuilder(this, item);
        }

        SeriesNestedImpl() {
            this.builder = new EventsV1EventSeriesBuilder(this);
        }

        public N and() {
             return (N) EventsV1EventFluentImpl.this.withSeries(builder.build());
        }

        public N endSeries() {
             return and();
        }
    }


}
