/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1beta1EndpointConditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Endpoint represents a single logical \"backend\" implementing a service.")
public class V1beta1Endpoint {
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<String> addresses = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private V1beta1EndpointConditions conditions;
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_TARGET_REF = "targetRef";
    @SerializedName(value="targetRef")
    private V1ObjectReference targetRef;
    public static final String SERIALIZED_NAME_TOPOLOGY = "topology";
    @SerializedName(value="topology")
    private Map<String, String> topology = null;

    public V1beta1Endpoint addresses(List<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public V1beta1Endpoint addAddressesItem(String addressesItem) {
        this.addresses.add(addressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="addresses of this endpoint. The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100.")
    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public V1beta1Endpoint conditions(V1beta1EndpointConditions conditions) {
        this.conditions = conditions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1EndpointConditions getConditions() {
        return this.conditions;
    }

    public void setConditions(V1beta1EndpointConditions conditions) {
        this.conditions = conditions;
    }

    public V1beta1Endpoint hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="hostname of this endpoint. This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must pass DNS Label (RFC 1123) validation.")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public V1beta1Endpoint targetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectReference getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    public V1beta1Endpoint topology(Map<String, String> topology) {
        this.topology = topology;
        return this;
    }

    public V1beta1Endpoint putTopologyItem(String key, String topologyItem) {
        if (this.topology == null) {
            this.topology = new HashMap<String, String>();
        }
        this.topology.put(key, topologyItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="topology contains arbitrary topology information associated with the endpoint. These key/value pairs must conform with the label format. https://kubernetes.io/docs/concepts/overview/working-with-objects/labels Topology may include a maximum of 16 key/value pairs. This includes, but is not limited to the following well known keys: * kubernetes.io/hostname: the value indicates the hostname of the node   where the endpoint is located. This should match the corresponding   node label. * topology.kubernetes.io/zone: the value indicates the zone where the   endpoint is located. This should match the corresponding node label. * topology.kubernetes.io/region: the value indicates the region where the   endpoint is located. This should match the corresponding node label.")
    public Map<String, String> getTopology() {
        return this.topology;
    }

    public void setTopology(Map<String, String> topology) {
        this.topology = topology;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1Endpoint v1beta1Endpoint = (V1beta1Endpoint)o;
        return Objects.equals(this.addresses, v1beta1Endpoint.addresses) && Objects.equals(this.conditions, v1beta1Endpoint.conditions) && Objects.equals(this.hostname, v1beta1Endpoint.hostname) && Objects.equals(this.targetRef, v1beta1Endpoint.targetRef) && Objects.equals(this.topology, v1beta1Endpoint.topology);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.hostname, this.targetRef, this.topology);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1Endpoint {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    targetRef: ").append(this.toIndentedString(this.targetRef)).append("\n");
        sb.append("    topology: ").append(this.toIndentedString(this.topology)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

