/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1VolumeProjection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a projected volume source")
public class V1ProjectedVolumeSource {
    public static final String SERIALIZED_NAME_DEFAULT_MODE = "defaultMode";
    @SerializedName(value="defaultMode")
    private Integer defaultMode;
    public static final String SERIALIZED_NAME_SOURCES = "sources";
    @SerializedName(value="sources")
    private List<V1VolumeProjection> sources = new ArrayList<V1VolumeProjection>();

    public V1ProjectedVolumeSource defaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.")
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
    }

    public V1ProjectedVolumeSource sources(List<V1VolumeProjection> sources) {
        this.sources = sources;
        return this;
    }

    public V1ProjectedVolumeSource addSourcesItem(V1VolumeProjection sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="list of volume projections")
    public List<V1VolumeProjection> getSources() {
        return this.sources;
    }

    public void setSources(List<V1VolumeProjection> sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ProjectedVolumeSource v1ProjectedVolumeSource = (V1ProjectedVolumeSource)o;
        return Objects.equals(this.defaultMode, v1ProjectedVolumeSource.defaultMode) && Objects.equals(this.sources, v1ProjectedVolumeSource.sources);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.sources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ProjectedVolumeSource {\n");
        sb.append("    defaultMode: ").append(this.toIndentedString(this.defaultMode)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

