/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.")
public class V2beta1ResourceMetricSource {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="targetAverageUtilization")
    private Integer targetAverageUtilization = null;
    @SerializedName(value="targetAverageValue")
    private String targetAverageValue = null;

    public V2beta1ResourceMetricSource name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is the name of the resource in question.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V2beta1ResourceMetricSource targetAverageUtilization(Integer targetAverageUtilization) {
        this.targetAverageUtilization = targetAverageUtilization;
        return this;
    }

    @ApiModelProperty(value="targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.")
    public Integer getTargetAverageUtilization() {
        return this.targetAverageUtilization;
    }

    public void setTargetAverageUtilization(Integer targetAverageUtilization) {
        this.targetAverageUtilization = targetAverageUtilization;
    }

    public V2beta1ResourceMetricSource targetAverageValue(String targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return this;
    }

    @ApiModelProperty(value="targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type.")
    public String getTargetAverageValue() {
        return this.targetAverageValue;
    }

    public void setTargetAverageValue(String targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1ResourceMetricSource v2beta1ResourceMetricSource = (V2beta1ResourceMetricSource)o;
        return Objects.equals(this.name, v2beta1ResourceMetricSource.name) && Objects.equals(this.targetAverageUtilization, v2beta1ResourceMetricSource.targetAverageUtilization) && Objects.equals(this.targetAverageValue, v2beta1ResourceMetricSource.targetAverageValue);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.targetAverageUtilization, this.targetAverageValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1ResourceMetricSource {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    targetAverageUtilization: ").append(this.toIndentedString(this.targetAverageUtilization)).append("\n");
        sb.append("    targetAverageValue: ").append(this.toIndentedString(this.targetAverageValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

