/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ExecAction;
import io.kubernetes.client.models.V1HTTPGetAction;
import io.kubernetes.client.models.V1TCPSocketAction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Handler defines a specific action that should be taken")
public class V1Handler {
    @SerializedName(value="exec")
    private V1ExecAction exec = null;
    @SerializedName(value="httpGet")
    private V1HTTPGetAction httpGet = null;
    @SerializedName(value="tcpSocket")
    private V1TCPSocketAction tcpSocket = null;

    public V1Handler exec(V1ExecAction exec) {
        this.exec = exec;
        return this;
    }

    @ApiModelProperty(value="One and only one of the following should be specified. Exec specifies the action to take.")
    public V1ExecAction getExec() {
        return this.exec;
    }

    public void setExec(V1ExecAction exec) {
        this.exec = exec;
    }

    public V1Handler httpGet(V1HTTPGetAction httpGet) {
        this.httpGet = httpGet;
        return this;
    }

    @ApiModelProperty(value="HTTPGet specifies the http request to perform.")
    public V1HTTPGetAction getHttpGet() {
        return this.httpGet;
    }

    public void setHttpGet(V1HTTPGetAction httpGet) {
        this.httpGet = httpGet;
    }

    public V1Handler tcpSocket(V1TCPSocketAction tcpSocket) {
        this.tcpSocket = tcpSocket;
        return this;
    }

    @ApiModelProperty(value="TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported")
    public V1TCPSocketAction getTcpSocket() {
        return this.tcpSocket;
    }

    public void setTcpSocket(V1TCPSocketAction tcpSocket) {
        this.tcpSocket = tcpSocket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Handler v1Handler = (V1Handler)o;
        return Objects.equals(this.exec, v1Handler.exec) && Objects.equals(this.httpGet, v1Handler.httpGet) && Objects.equals(this.tcpSocket, v1Handler.tcpSocket);
    }

    public int hashCode() {
        return Objects.hash(this.exec, this.httpGet, this.tcpSocket);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Handler {\n");
        sb.append("    exec: ").append(this.toIndentedString(this.exec)).append("\n");
        sb.append("    httpGet: ").append(this.toIndentedString(this.httpGet)).append("\n");
        sb.append("    tcpSocket: ").append(this.toIndentedString(this.tcpSocket)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

