/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ConfigMapProjection;
import io.kubernetes.client.models.V1DownwardAPIProjection;
import io.kubernetes.client.models.V1SecretProjection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Projection that may be projected along with other supported volume types")
public class V1VolumeProjection {
    @SerializedName(value="configMap")
    private V1ConfigMapProjection configMap = null;
    @SerializedName(value="downwardAPI")
    private V1DownwardAPIProjection downwardAPI = null;
    @SerializedName(value="secret")
    private V1SecretProjection secret = null;

    public V1VolumeProjection configMap(V1ConfigMapProjection configMap) {
        this.configMap = configMap;
        return this;
    }

    @ApiModelProperty(value="information about the configMap data to project")
    public V1ConfigMapProjection getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(V1ConfigMapProjection configMap) {
        this.configMap = configMap;
    }

    public V1VolumeProjection downwardAPI(V1DownwardAPIProjection downwardAPI) {
        this.downwardAPI = downwardAPI;
        return this;
    }

    @ApiModelProperty(value="information about the downwardAPI data to project")
    public V1DownwardAPIProjection getDownwardAPI() {
        return this.downwardAPI;
    }

    public void setDownwardAPI(V1DownwardAPIProjection downwardAPI) {
        this.downwardAPI = downwardAPI;
    }

    public V1VolumeProjection secret(V1SecretProjection secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(value="information about the secret data to project")
    public V1SecretProjection getSecret() {
        return this.secret;
    }

    public void setSecret(V1SecretProjection secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeProjection v1VolumeProjection = (V1VolumeProjection)o;
        return Objects.equals(this.configMap, v1VolumeProjection.configMap) && Objects.equals(this.downwardAPI, v1VolumeProjection.downwardAPI) && Objects.equals(this.secret, v1VolumeProjection.secret);
    }

    public int hashCode() {
        return Objects.hash(this.configMap, this.downwardAPI, this.secret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeProjection {\n");
        sb.append("    configMap: ").append(this.toIndentedString(this.configMap)).append("\n");
        sb.append("    downwardAPI: ").append(this.toIndentedString(this.downwardAPI)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

