/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V2alpha1MetricStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.")
public class V2alpha1HorizontalPodAutoscalerStatus {
    @SerializedName(value="currentMetrics")
    private List<V2alpha1MetricStatus> currentMetrics = new ArrayList<V2alpha1MetricStatus>();
    @SerializedName(value="currentReplicas")
    private Integer currentReplicas = null;
    @SerializedName(value="desiredReplicas")
    private Integer desiredReplicas = null;
    @SerializedName(value="lastScaleTime")
    private DateTime lastScaleTime = null;
    @SerializedName(value="observedGeneration")
    private Long observedGeneration = null;

    public V2alpha1HorizontalPodAutoscalerStatus currentMetrics(List<V2alpha1MetricStatus> currentMetrics) {
        this.currentMetrics = currentMetrics;
        return this;
    }

    public V2alpha1HorizontalPodAutoscalerStatus addCurrentMetricsItem(V2alpha1MetricStatus currentMetricsItem) {
        this.currentMetrics.add(currentMetricsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="currentMetrics is the last read state of the metrics used by this autoscaler.")
    public List<V2alpha1MetricStatus> getCurrentMetrics() {
        return this.currentMetrics;
    }

    public void setCurrentMetrics(List<V2alpha1MetricStatus> currentMetrics) {
        this.currentMetrics = currentMetrics;
    }

    public V2alpha1HorizontalPodAutoscalerStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.")
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public V2alpha1HorizontalPodAutoscalerStatus desiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.")
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public void setDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
    }

    public V2alpha1HorizontalPodAutoscalerStatus lastScaleTime(DateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return this;
    }

    @ApiModelProperty(value="lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.")
    public DateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    public void setLastScaleTime(DateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
    }

    public V2alpha1HorizontalPodAutoscalerStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @ApiModelProperty(value="observedGeneration is the most recent generation observed by this autoscaler.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2alpha1HorizontalPodAutoscalerStatus v2alpha1HorizontalPodAutoscalerStatus = (V2alpha1HorizontalPodAutoscalerStatus)o;
        return Objects.equals(this.currentMetrics, v2alpha1HorizontalPodAutoscalerStatus.currentMetrics) && Objects.equals(this.currentReplicas, v2alpha1HorizontalPodAutoscalerStatus.currentReplicas) && Objects.equals(this.desiredReplicas, v2alpha1HorizontalPodAutoscalerStatus.desiredReplicas) && Objects.equals(this.lastScaleTime, v2alpha1HorizontalPodAutoscalerStatus.lastScaleTime) && Objects.equals(this.observedGeneration, v2alpha1HorizontalPodAutoscalerStatus.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.currentMetrics, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2alpha1HorizontalPodAutoscalerStatus {\n");
        sb.append("    currentMetrics: ").append(this.toIndentedString(this.currentMetrics)).append("\n");
        sb.append("    currentReplicas: ").append(this.toIndentedString(this.currentReplicas)).append("\n");
        sb.append("    desiredReplicas: ").append(this.toIndentedString(this.desiredReplicas)).append("\n");
        sb.append("    lastScaleTime: ").append(this.toIndentedString(this.lastScaleTime)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

