/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1beta1TokenReviewSpec;
import io.kubernetes.client.models.V1beta1TokenReviewStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="TokenReview attempts to authenticate a token to a known user. Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.")
public class V1beta1TokenReview {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="spec")
    private V1beta1TokenReviewSpec spec = null;
    @SerializedName(value="status")
    private V1beta1TokenReviewStatus status = null;

    public V1beta1TokenReview apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1beta1TokenReview kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1beta1TokenReview metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1beta1TokenReview spec(V1beta1TokenReviewSpec spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(required=true, value="Spec holds information about the request being evaluated")
    public V1beta1TokenReviewSpec getSpec() {
        return this.spec;
    }

    public void setSpec(V1beta1TokenReviewSpec spec) {
        this.spec = spec;
    }

    public V1beta1TokenReview status(V1beta1TokenReviewStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status is filled in by the server and indicates whether the request can be authenticated.")
    public V1beta1TokenReviewStatus getStatus() {
        return this.status;
    }

    public void setStatus(V1beta1TokenReviewStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1TokenReview v1beta1TokenReview = (V1beta1TokenReview)o;
        return Objects.equals(this.apiVersion, v1beta1TokenReview.apiVersion) && Objects.equals(this.kind, v1beta1TokenReview.kind) && Objects.equals(this.metadata, v1beta1TokenReview.metadata) && Objects.equals(this.spec, v1beta1TokenReview.spec) && Objects.equals(this.status, v1beta1TokenReview.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1TokenReview {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

