/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="ResourceRequirements describes the compute resource requirements.")
public class V1ResourceRequirements {
    @SerializedName(value="limits")
    private Map<String, String> limits = null;
    @SerializedName(value="requests")
    private Map<String, String> requests = null;

    public V1ResourceRequirements limits(Map<String, String> limits) {
        this.limits = limits;
        return this;
    }

    public V1ResourceRequirements putLimitsItem(String key, String limitsItem) {
        if (this.limits == null) {
            this.limits = new HashMap<String, String>();
        }
        this.limits.put(key, limitsItem);
        return this;
    }

    @ApiModelProperty(value="Limits describes the maximum amount of compute resources allowed. More info: http://kubernetes.io/docs/user-guide/compute-resources/")
    public Map<String, String> getLimits() {
        return this.limits;
    }

    public void setLimits(Map<String, String> limits) {
        this.limits = limits;
    }

    public V1ResourceRequirements requests(Map<String, String> requests) {
        this.requests = requests;
        return this;
    }

    public V1ResourceRequirements putRequestsItem(String key, String requestsItem) {
        if (this.requests == null) {
            this.requests = new HashMap<String, String>();
        }
        this.requests.put(key, requestsItem);
        return this;
    }

    @ApiModelProperty(value="Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: http://kubernetes.io/docs/user-guide/compute-resources/")
    public Map<String, String> getRequests() {
        return this.requests;
    }

    public void setRequests(Map<String, String> requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceRequirements v1ResourceRequirements = (V1ResourceRequirements)o;
        return Objects.equals(this.limits, v1ResourceRequirements.limits) && Objects.equals(this.requests, v1ResourceRequirements.requests);
    }

    public int hashCode() {
        return Objects.hash(this.limits, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceRequirements {\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

