/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.")
public class V1NFSVolumeSource {
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;
    @SerializedName(value="server")
    private String server = null;

    public V1NFSVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Path that is exported by the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1NFSVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#nfs")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1NFSVolumeSource server(String server) {
        this.server = server;
        return this;
    }

    @ApiModelProperty(required=true, value="Server is the hostname or IP address of the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs")
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NFSVolumeSource v1NFSVolumeSource = (V1NFSVolumeSource)o;
        return Objects.equals(this.path, v1NFSVolumeSource.path) && Objects.equals(this.readOnly, v1NFSVolumeSource.readOnly) && Objects.equals(this.server, v1NFSVolumeSource.server);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.readOnly, this.server);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NFSVolumeSource {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    server: ").append(this.toIndentedString(this.server)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

