/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1HorizontalPodAutoscalerSpec;
import io.kubernetes.client.models.V1HorizontalPodAutoscalerStatus;
import io.kubernetes.client.models.V1ObjectMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="configuration of a horizontal pod autoscaler.")
public class V1HorizontalPodAutoscaler {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="spec")
    private V1HorizontalPodAutoscalerSpec spec = null;
    @SerializedName(value="status")
    private V1HorizontalPodAutoscalerStatus status = null;

    public V1HorizontalPodAutoscaler apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1HorizontalPodAutoscaler kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1HorizontalPodAutoscaler metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Standard object metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1HorizontalPodAutoscaler spec(V1HorizontalPodAutoscalerSpec spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(value="behaviour of autoscaler. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#spec-and-status.")
    public V1HorizontalPodAutoscalerSpec getSpec() {
        return this.spec;
    }

    public void setSpec(V1HorizontalPodAutoscalerSpec spec) {
        this.spec = spec;
    }

    public V1HorizontalPodAutoscaler status(V1HorizontalPodAutoscalerStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="current information about the autoscaler.")
    public V1HorizontalPodAutoscalerStatus getStatus() {
        return this.status;
    }

    public void setStatus(V1HorizontalPodAutoscalerStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HorizontalPodAutoscaler v1HorizontalPodAutoscaler = (V1HorizontalPodAutoscaler)o;
        return Objects.equals(this.apiVersion, v1HorizontalPodAutoscaler.apiVersion) && Objects.equals(this.kind, v1HorizontalPodAutoscaler.kind) && Objects.equals(this.metadata, v1HorizontalPodAutoscaler.metadata) && Objects.equals(this.spec, v1HorizontalPodAutoscaler.spec) && Objects.equals(this.status, v1HorizontalPodAutoscaler.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1HorizontalPodAutoscaler {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

