/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1beta1NetworkPolicyIngressRule;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V1beta1NetworkPolicySpec {
    @SerializedName(value="ingress")
    private List<V1beta1NetworkPolicyIngressRule> ingress = null;
    @SerializedName(value="podSelector")
    private V1LabelSelector podSelector = null;

    public V1beta1NetworkPolicySpec ingress(List<V1beta1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
        return this;
    }

    public V1beta1NetworkPolicySpec addIngressItem(V1beta1NetworkPolicyIngressRule ingressItem) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRule>();
        }
        this.ingress.add(ingressItem);
        return this;
    }

    @ApiModelProperty(value="List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if namespace.networkPolicy.ingress.isolation is undefined and cluster policy allows it, OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not affect ingress isolation. If this field is present and contains at least one rule, this policy allows any traffic which matches at least one of the ingress rules in this list.")
    public List<V1beta1NetworkPolicyIngressRule> getIngress() {
        return this.ingress;
    }

    public void setIngress(List<V1beta1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
    }

    public V1beta1NetworkPolicySpec podSelector(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
        return this;
    }

    @ApiModelProperty(required=true, value="Selects the pods to which this NetworkPolicy object applies.  The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods.  In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.")
    public V1LabelSelector getPodSelector() {
        return this.podSelector;
    }

    public void setPodSelector(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1NetworkPolicySpec v1beta1NetworkPolicySpec = (V1beta1NetworkPolicySpec)o;
        return Objects.equals(this.ingress, v1beta1NetworkPolicySpec.ingress) && Objects.equals(this.podSelector, v1beta1NetworkPolicySpec.podSelector);
    }

    public int hashCode() {
        return Objects.hash(this.ingress, this.podSelector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1NetworkPolicySpec {\n");
        sb.append("    ingress: ").append(this.toIndentedString(this.ingress)).append("\n");
        sb.append("    podSelector: ").append(this.toIndentedString(this.podSelector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

